/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.example.authn;

import io.swagger.annotations.Api;
import io.swagger.annotations.Info;
import io.swagger.annotations.SwaggerDefinition;
import java.net.URI;
import java.text.ParseException;
import javax.annotation.security.PermitAll;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import net.trajano.ms.auth.token.OAuthTokenResponse;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import net.trajano.ms.core.CryptoOps;
import org.jose4j.jwt.JwtClaims;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@SwaggerDefinition(info=@Info(title="Sample Authn Microservice", version="1.0"))
@Api
@Component
@Path(value="/authn")
@PermitAll
public class AuthnResource {
    @Value(value="${authorizationEndpoint}")
    private URI authorizationEndpoint;
    @Context
    private Client client;
    @Autowired
    private CryptoOps cryptoOps;

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/json"})
    public OAuthTokenResponse json(@FormParam(value="j_username") String username, @FormParam(value="j_password") String password, @HeaderParam(value="Authorization") String authorization) {
        if (!"password".equals(password)) {
            throw OAuthTokenResponse.unauthorized((String)"unauthorized_client", (String)"invalid username/password combination", (String)"FORM");
        }
        JwtClaims claims = new JwtClaims();
        claims.setSubject(username);
        try {
            claims.setAudience(HttpAuthorizationHeaders.parseBasicAuthorization((String)authorization)[0]);
        }
        catch (ParseException e) {
            throw OAuthTokenResponse.unauthorized((String)"unauthorized_client", (String)"Invalid or missing authorization", (String)String.format("Basic realm=\"%s\", encoding=\"UTF-8\"", "authz"));
        }
        Form form = new Form();
        form.param("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        form.param("assertion", this.cryptoOps.sign(claims));
        return (OAuthTokenResponse)this.client.target(this.authorizationEndpoint).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).header("Authorization", (Object)authorization).post(Entity.form((Form)form), OAuthTokenResponse.class);
    }
}

