/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.spi;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import net.trajano.ms.auth.util.HttpAuthorizationHeaders;
import net.trajano.ms.oidc.OpenIdConfiguration;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class IssuerConfig {
    @XmlElement(name="client_id", required=true)
    private String clientId;
    @XmlElement(name="client_secret", required=true)
    private String clientSecret;
    @XmlElement(name="display")
    private String display;
    @XmlElement(required=true)
    private String id;
    @XmlTransient
    private HttpsJwks jwkset;
    @XmlTransient
    private OpenIdConfiguration openIdConfiguration;
    @XmlElement(name="prompt")
    private String prompt;
    @XmlElement(name="redirect_uri", required=true)
    private URI redirectUri;
    @XmlElement(name="scope", required=true)
    private String scope;
    @XmlElement(required=true)
    private URI uri;

    public URI buildAuthenticationRequestUri(URI redirectUri, String state, String nonce) {
        this.openIdConfiguration.getAuthorizationEndpoint();
        UriBuilder b = UriBuilder.fromUri((URI)this.openIdConfiguration.getAuthorizationEndpoint()).queryParam("response_type", new Object[]{"code"}).queryParam("scope", new Object[]{this.scope}).queryParam("client_id", new Object[]{this.clientId}).queryParam("redirect_uri", new Object[]{redirectUri}).queryParam("nonce", new Object[]{nonce});
        if (state != null) {
            b.queryParam("state", new Object[]{state});
        }
        if (this.display != null) {
            b.queryParam("display", new Object[]{this.display});
        }
        if (this.prompt != null) {
            b.queryParam("prompt", new Object[]{this.prompt});
        }
        return b.build(new Object[0]);
    }

    public String buildAuthorization() {
        return HttpAuthorizationHeaders.buildBasicAuthorization((String)this.clientId, (String)this.clientSecret);
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getId() {
        return this.id;
    }

    public JsonWebKeySet getJwks() {
        try {
            if (this.jwkset == null) {
                this.jwkset = new HttpsJwks(this.getOpenIdConfiguration().getJwksUri().toASCIIString());
            }
            return new JsonWebKeySet(this.jwkset.getJsonWebKeys());
        }
        catch (JoseException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public OpenIdConfiguration getOpenIdConfiguration() {
        return this.openIdConfiguration;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public URI getRedirectUri() {
        return this.redirectUri;
    }

    public String getScope() {
        return this.scope;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setOpenIdConfiguration(OpenIdConfiguration openIdConfiguration) {
        this.openIdConfiguration = openIdConfiguration;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setRedirectUri(URI redirectUri) {
        this.redirectUri = redirectUri;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

