/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.test;

import java.net.URI;
import net.trajano.ms.authz.spi.ClientValidator;
import net.trajano.ms.oidc.OpenIdConfiguration;
import net.trajano.ms.oidc.spi.IssuerConfig;
import net.trajano.ms.oidc.spi.ServiceConfiguration;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TestConfig {
    @Bean
    public ClientValidator clientValidator() throws Exception {
        ClientValidator mock = (ClientValidator)Mockito.mock(ClientValidator.class);
        Mockito.when((Object)mock.isValid((String)Matchers.eq((Object)"openid"), Matchers.anyString())).thenReturn((Object)true);
        return mock;
    }

    @Bean
    public ServiceConfiguration serviceConfiguration() {
        ServiceConfiguration mock = (ServiceConfiguration)Mockito.mock(ServiceConfiguration.class);
        OpenIdConfiguration openIdConfiguration = new OpenIdConfiguration();
        openIdConfiguration.setAuthorizationEndpoint(URI.create("http://example.trajano.net"));
        IssuerConfig issuerConfig = new IssuerConfig();
        issuerConfig.setOpenIdConfiguration(openIdConfiguration);
        issuerConfig.setScope("openid");
        issuerConfig.setClientId("clientid");
        issuerConfig.setClientSecret("clientsecret");
        Mockito.when((Object)mock.getIssuerConfig("issuer")).thenReturn((Object)issuerConfig);
        Mockito.when((Object)mock.getRedirectUri()).thenReturn((Object)URI.create("http://example.trajano.net"));
        return mock;
    }
}

