/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc;

import com.google.gson.JsonObject;
import io.swagger.annotations.Api;
import java.net.URI;
import javax.annotation.PostConstruct;
import javax.annotation.security.PermitAll;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import net.trajano.ms.auth.token.OAuthTokenResponse;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.core.ErrorResponses;
import net.trajano.ms.oidc.OpenIdConfiguration;
import net.trajano.ms.oidc.internal.AuthenticationUriBuilder;
import net.trajano.ms.oidc.internal.ServerState;
import net.trajano.ms.oidc.spi.IssuerConfig;
import net.trajano.ms.oidc.spi.ServiceConfiguration;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Api
@Component
@Path(value="/oidc")
@PermitAll
public class OpenIdConnectResource {
    private static final String ID_TOKEN = "id_token";
    private static final Logger LOG = LoggerFactory.getLogger(OpenIdConnectResource.class);
    @Autowired
    private AuthenticationUriBuilder authenticationUriBuilder;
    @Value(value="${authorization.endpoint}")
    private URI authorizationEndpoint;
    @Context
    private Client client;
    @Autowired
    private CacheManager cm;
    @Autowired
    private CryptoOps cryptoOps;
    private Cache serverStateCache;
    @Autowired
    private ServiceConfiguration serviceConfiguration;

    @Path(value="/auth/{issuer_id}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response auth(@FormParam(value="state") String state, @PathParam(value="issuer_id") String issuerId, @HeaderParam(value="Authorization") String authorization) {
        return Response.seeOther((URI)this.authUri(state, issuerId, authorization)).build();
    }

    @Path(value="/auth-uri/{issuer_id}")
    @GET
    @Produces(value={"text/plain"})
    public URI authUri(@QueryParam(value="state") String state, @PathParam(value="issuer_id") String issuerId, @HeaderParam(value="Authorization") String authorization) {
        this.getRedirectUri(authorization);
        return this.authenticationUriBuilder.build(state, issuerId, authorization, new JwtClaims());
    }

    @Path(value="/auth-info/{issuer_id}")
    @GET
    @Produces(value={"application/json"})
    public JsonObject authUriJson(@QueryParam(value="state") String state, @PathParam(value="issuer_id") String issuerId, @HeaderParam(value="Authorization") String authorization) {
        JsonObject uriObject = new JsonObject();
        uriObject.addProperty("uri", this.authUri(state, issuerId, authorization).toASCIIString());
        return uriObject;
    }

    @Path(value="/cb/{issuer_id}")
    @GET
    public Response callback(@QueryParam(value="code") String code, @QueryParam(value="state") String jwtState, @PathParam(value="issuer_id") String issuerId) throws MalformedClaimException {
        if (issuerId == null) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Missing issuer_id");
        }
        IssuerConfig issuerConfig = this.serviceConfiguration.getIssuerConfig(issuerId);
        if (issuerConfig == null) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Invalid issuer_id");
        }
        ServerState serverState = (ServerState)this.serverStateCache.get((Object)jwtState, ServerState.class);
        if (serverState == null) {
            throw ErrorResponses.badRequest((String)"invalid_request", (String)"Invalid state");
        }
        URI redirectUri = UriBuilder.fromUri((URI)this.serviceConfiguration.getRedirectUri()).path(issuerId).build(new Object[0]);
        Form form = new Form();
        form.param("redirect_uri", redirectUri.toASCIIString());
        form.param("grant_type", "authorization_code");
        form.param("code", code);
        OpenIdConfiguration openIdConfiguration = issuerConfig.getOpenIdConfiguration();
        URI tokenEndpoint = openIdConfiguration.getTokenEndpoint();
        Response clientResponse = this.client.target(tokenEndpoint).request(new String[]{"application/json"}).header("Authorization", (Object)issuerConfig.buildAuthorization()).post(Entity.form((Form)form));
        JsonObject openIdToken = (JsonObject)clientResponse.readEntity(JsonObject.class);
        if (clientResponse.getStatus() != Response.Status.OK.getStatusCode()) {
            LOG.error("Received = {} from {}", (Object)openIdToken, (Object)tokenEndpoint);
            throw ErrorResponses.internalServerError((String)"server unable to get id_token");
        }
        JwtClaims idTokenClaims = this.cryptoOps.toClaimsSet(openIdToken.get(ID_TOKEN).getAsString(), openIdConfiguration.getHttpsJwks());
        if (!serverState.getNonce().equals(idTokenClaims.getStringClaimValue("nonce"))) {
            throw ErrorResponses.internalServerError((String)"nonce did not match");
        }
        serverState.getAdditionalClaims().getClaimsMap().forEach((k, v) -> {
            if (idTokenClaims.hasClaim(k)) {
                throw new InternalServerErrorException("The claim " + k + " already exists from the IP");
            }
            idTokenClaims.setClaim(k, v);
        });
        Form storeInternalForm = new Form();
        storeInternalForm.param("grant_type", "urn:ietf:params:oauth:grant-type:jwt-bearer");
        storeInternalForm.param("assertion", this.cryptoOps.sign(idTokenClaims));
        storeInternalForm.param("aud", issuerConfig.getClientId());
        OAuthTokenResponse tokenResponse = (OAuthTokenResponse)this.client.target(this.authorizationEndpoint).path("/token").request(new String[]{"application/json"}).header("Authorization", (Object)serverState.getClientCredentials()).post(Entity.form((Form)storeInternalForm), OAuthTokenResponse.class);
        URI redirectUri1 = this.getRedirectUri(serverState.getClientCredentials());
        URI newUri = tokenResponse.isExpiring() ? UriBuilder.fromUri((URI)redirectUri1).fragment("state={state}&access_token={access_token}&refresh_token={refresh_token}&token_type={token_type}&expires_in={expires_in}").build(new Object[]{serverState.getClientState(), tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getTokenType(), tokenResponse.getExpiresIn()}) : UriBuilder.fromUri((URI)redirectUri1).fragment("state={state}&access_token={access_token}&refresh_token={refresh_token}&token_type={token_type}").build(new Object[]{serverState.getClientState(), tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getTokenType()});
        return Response.temporaryRedirect((URI)newUri).build();
    }

    private URI getRedirectUri(String authorization) {
        try {
            LOG.debug("Obtaining redirect URI using authorization={}", (Object)authorization);
            return URI.create((String)this.client.target(this.authorizationEndpoint).path("/check/openid-redirect-uri").request(new String[]{"text/plain"}).header("Authorization", (Object)authorization).get(String.class));
        }
        catch (BadRequestException e) {
            throw ErrorResponses.invalidAuthorization();
        }
    }

    @PostConstruct
    public void init() {
        this.serverStateCache = this.cm.getCache("server_state");
    }

    public void setClient(Client client) {
        this.client = client;
    }
}

