/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.List;
import javax.ws.rs.InternalServerErrorException;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.jose4j.jwk.HttpsJwks;
import org.jose4j.jwk.JsonWebKeySet;
import org.jose4j.lang.JoseException;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
@JsonIgnoreProperties(ignoreUnknown=true)
public class OpenIdConfiguration {
    @XmlElement(name="authorization_endpoint")
    private URI authorizationEndpoint;
    @XmlTransient
    private HttpsJwks httpsJwks;
    @XmlElement(name="issuer")
    private String issuer;
    @XmlElement(name="jwks_uri")
    private URI jwksUri;
    @XmlElement(name="response_types_supported", type=String.class)
    private List<String> responseTypesSupported;
    @XmlElement(name="revocation_endpoint")
    private URI revocationEndpoint;
    @XmlElement(name="token_endpoint")
    private URI tokenEndpoint;
    @XmlElement(name="userinfo_endpoint")
    private URI userinfoEndpoint;

    public URI getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public HttpsJwks getHttpsJwks() {
        if (this.httpsJwks == null) {
            this.httpsJwks = new HttpsJwks(this.jwksUri.toASCIIString());
        }
        return this.httpsJwks;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public JsonWebKeySet getJwks() {
        try {
            return new JsonWebKeySet(this.getHttpsJwks().getJsonWebKeys());
        }
        catch (JoseException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public URI getJwksUri() {
        return this.jwksUri;
    }

    public List<String> getResponseTypesSupported() {
        return this.responseTypesSupported;
    }

    public URI getRevocationEndpoint() {
        return this.revocationEndpoint;
    }

    public URI getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    public URI getUserinfoEndpoint() {
        return this.userinfoEndpoint;
    }

    public void setAuthorizationEndpoint(URI authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setJwksUri(URI jwksUri) {
        this.jwksUri = jwksUri;
    }

    public void setResponseTypesSupported(List<String> responseTypesSupported) {
        this.responseTypesSupported = responseTypesSupported;
    }

    public void setRevocationEndpoint(URI revocationEndpoint) {
        this.revocationEndpoint = revocationEndpoint;
    }

    public void setTokenEndpoint(URI tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
    }

    public void setUserinfoEndpoint(URI userinfoEndpoint) {
        this.userinfoEndpoint = userinfoEndpoint;
    }
}

