/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.test;

import com.google.gson.JsonObject;
import java.net.URI;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import net.trajano.ms.oidc.OpenIdConnect;
import net.trajano.ms.oidc.OpenIdConnectResource;
import net.trajano.ms.oidc.internal.AuthenticationUriBuilder;
import net.trajano.ms.oidc.test.TestConfig;
import net.trajano.ms.vertx.VertxConfig;
import org.jose4j.jwt.JwtClaims;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={VertxConfig.class, ConcurrentMapCacheManager.class, AuthenticationUriBuilder.class, OpenIdConnect.class, OpenIdConnectResource.class, TestConfig.class})
@TestPropertySource(properties={"authorization.endpoint=http://example.trajano.net"})
public class OpenIdConnectMSTest {
    @Autowired
    private AuthenticationUriBuilder builder;
    @Autowired
    private OpenIdConnect ms;
    @Autowired
    private OpenIdConnectResource resource;

    @Test
    public void builderTest() {
        this.builder.build("state", "issuer", "auhtoriation", new JwtClaims());
    }

    @Test
    public void exampleTest() {
        Assert.assertNotNull((Object)this.ms);
    }

    @Test
    public void testOidcResource() {
        Assert.assertNotNull((Object)this.resource);
        Client client = (Client)Mockito.mock(Client.class);
        WebTarget webTarget = (WebTarget)Mockito.mock(WebTarget.class);
        Mockito.when((Object)client.target((URI)Matchers.any(URI.class))).thenReturn((Object)webTarget);
        Mockito.when((Object)webTarget.path(Matchers.anyString())).thenReturn((Object)webTarget);
        Invocation.Builder builder = (Invocation.Builder)Mockito.mock(Invocation.Builder.class);
        Mockito.when((Object)webTarget.request(new String[]{Matchers.anyString()})).thenReturn((Object)builder);
        Mockito.when((Object)builder.header(Matchers.anyString(), (Object)Matchers.anyString())).thenReturn((Object)builder);
        Mockito.when((Object)builder.get(String.class)).thenReturn((Object)"http://callback.trajano.net");
        this.resource.setClient(client);
        Response auth = this.resource.auth("abc", "issuer", "jdk");
        Assert.assertEquals((Object)"example.trajano.net", (Object)URI.create(auth.getHeaderString("Location")).getHost());
        JsonObject authUriJson = this.resource.authUriJson("abc", "issuer", "jdk");
        Assert.assertEquals((Object)"example.trajano.net", (Object)URI.create(authUriJson.get("uri").getAsString()).getHost());
    }
}

