/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.internal;

import java.io.Serializable;
import javax.ws.rs.InternalServerErrorException;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.InvalidJwtException;

public class ServerState
implements Serializable {
    private static final long serialVersionUID = -8675497431930478448L;
    private final String additionalClaimsJson;
    private final String clientCredentials;
    private final String clientState;
    private final String nonce;

    public ServerState(String clientState, JwtClaims additionalClaims, String nonce, String clientCredentials) {
        this.clientState = clientState;
        this.additionalClaimsJson = additionalClaims.toJson();
        this.nonce = nonce;
        this.clientCredentials = clientCredentials;
    }

    public JwtClaims getAdditionalClaims() {
        try {
            return JwtClaims.parse((String)this.additionalClaimsJson);
        }
        catch (InvalidJwtException e) {
            throw new InternalServerErrorException((Throwable)e);
        }
    }

    public String getClientCredentials() {
        return this.clientCredentials;
    }

    public String getClientState() {
        return this.clientState;
    }

    public String getNonce() {
        return this.nonce;
    }
}

