/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.internal;

import com.hazelcast.config.Config;
import com.hazelcast.config.EntryListenerConfig;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class HazelcastConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(HazelcastConfiguration.class);
    public static final String SERVER_STATE = "server_state";
    @Value(value="${cache.instance_name:authz}")
    private String instanceName;
    @Value(value="${token.jwk_expiration:1800}")
    private int jwkExpirationInSeconds;
    @Value(value="${oidc.server_state_expiration:3600}")
    private int serverStateExpiration;

    @Bean
    public Config hazelcastConfig() {
        EntryListenerConfig listener = new EntryListenerConfig();
        Config config = new Config().setNetworkConfig(new NetworkConfig().setJoin(new JoinConfig().setMulticastConfig(new MulticastConfig().setEnabled(true)))).setInstanceName(this.instanceName).setProperty("hazelcast.logging.type", "slf4j").addMapConfig(new MapConfig().setName(SERVER_STATE).setTimeToLiveSeconds(this.serverStateExpiration).setMaxIdleSeconds(this.serverStateExpiration)).addMapConfig(new MapConfig().setName("jwks_cache").setTimeToLiveSeconds(this.jwkExpirationInSeconds).setMaxIdleSeconds(this.jwkExpirationInSeconds).addEntryListenerConfig(listener));
        LOG.debug("hazelcast config={}", (Object)config);
        return config;
    }
}

