/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.internal;

import java.net.URI;
import java.text.ParseException;
import javax.annotation.PostConstruct;
import javax.ws.rs.core.UriBuilder;
import net.trajano.ms.auth.spi.ClientValidator;
import net.trajano.ms.auth.token.OAuthTokenResponse;
import net.trajano.ms.core.CryptoOps;
import net.trajano.ms.oidc.internal.ServerState;
import net.trajano.ms.oidc.spi.IssuerConfig;
import net.trajano.ms.oidc.spi.ServiceConfiguration;
import org.jose4j.jwt.JwtClaims;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationUriBuilder {
    @Autowired
    private ClientValidator clientValidator;
    @Autowired
    private CacheManager cm;
    @Autowired
    private CryptoOps cryptoOps;
    private Cache nonceCache;
    @Value(value="${realmName:client_credentials}")
    private String realmName;
    @Autowired
    private ServiceConfiguration serviceConfiguration;

    public URI build(String state, String issuerId, String authorization, JwtClaims additionalClaims) {
        if (issuerId == null) {
            throw OAuthTokenResponse.badRequest((String)"invalid_request", (String)"Missing issuer_id");
        }
        if (state == null) {
            throw OAuthTokenResponse.badRequest((String)"invalid_request", (String)"Missing state");
        }
        IssuerConfig issuerConfig = this.serviceConfiguration.getIssuerConfig(issuerId);
        if (issuerConfig == null) {
            throw OAuthTokenResponse.badRequest((String)"invalid_request", (String)"Invalid issuer_id");
        }
        try {
            if (!this.clientValidator.isValid("openid", authorization)) {
                throw OAuthTokenResponse.unauthorized((String)"unauthorized_client", (String)"Unauthorized client", (String)String.format("Basic realm=\"%s\", encoding=\"UTF-8\"", this.realmName));
            }
        }
        catch (ParseException e) {
            throw OAuthTokenResponse.unauthorized((String)"unauthorized_client", (String)"Unable to parse client credentials", (String)String.format("Basic realm=\"%s\", encoding=\"UTF-8\"", this.realmName));
        }
        URI redirectUri = UriBuilder.fromUri((URI)this.serviceConfiguration.getRedirectUri()).path(issuerId).build(new Object[0]);
        String nonce = this.cryptoOps.newToken();
        ServerState serverState = new ServerState(state, additionalClaims, nonce, authorization);
        String cacheKey = this.cryptoOps.newToken();
        this.nonceCache.putIfAbsent((Object)cacheKey, (Object)serverState);
        return issuerConfig.buildAuthenticationRequestUri(redirectUri, cacheKey, nonce);
    }

    @PostConstruct
    public void init() {
        this.nonceCache = this.cm.getCache("server_state");
    }
}

