/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.jta.bitronix;

import bitronix.tm.resource.common.ResourceBean;
import bitronix.tm.resource.common.XAStatefulHolder;
import bitronix.tm.resource.jdbc.PoolingDataSource;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.lang.UsesJava7;
import org.springframework.util.StringUtils;

@ConfigurationProperties(prefix="spring.jta.bitronix.datasource")
public class PoolingDataSourceBean
extends PoolingDataSource
implements BeanNameAware,
InitializingBean {
    private static final ThreadLocal<PoolingDataSourceBean> source = new ThreadLocal();
    private XADataSource dataSource;
    private String beanName;

    public PoolingDataSourceBean() {
        this.setMaxPoolSize(10);
        this.setAllowLocalTransactions(true);
        this.setEnableJdbc4ConnectionTest(true);
    }

    public synchronized void init() {
        source.set(this);
        try {
            super.init();
        }
        finally {
            source.remove();
        }
    }

    @Override
    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasLength(this.getUniqueName())) {
            this.setUniqueName(this.beanName);
        }
    }

    public void setDataSource(XADataSource dataSource) {
        this.dataSource = dataSource;
        this.setClassName(DirectXADataSource.class.getName());
        this.setDriverProperties(new Properties());
    }

    protected final XADataSource getDataSource() {
        return this.dataSource;
    }

    public XAStatefulHolder createPooledConnection(Object xaFactory, ResourceBean bean) throws Exception {
        if (xaFactory instanceof DirectXADataSource) {
            xaFactory = ((DirectXADataSource)xaFactory).getDataSource();
        }
        return super.createPooledConnection(xaFactory, bean);
    }

    @UsesJava7
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        try {
            return this.getParentLogger();
        }
        catch (Exception ex) {
            return Logger.getLogger("global");
        }
    }

    static /* synthetic */ ThreadLocal access$000() {
        return source;
    }

    static /* synthetic */ XADataSource access$100(PoolingDataSourceBean x0) {
        return x0.dataSource;
    }

    public static class DirectXADataSource
    implements XADataSource {
        private final XADataSource dataSource = PoolingDataSourceBean.access$100((PoolingDataSourceBean)PoolingDataSourceBean.access$000().get());

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            return this.dataSource.getLogWriter();
        }

        @Override
        public XAConnection getXAConnection() throws SQLException {
            return this.dataSource.getXAConnection();
        }

        @Override
        public XAConnection getXAConnection(String user, String password) throws SQLException {
            return this.dataSource.getXAConnection(user, password);
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            this.dataSource.setLogWriter(out);
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this.dataSource.setLoginTimeout(seconds);
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            return this.dataSource.getLoginTimeout();
        }

        @Override
        @UsesJava7
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return this.dataSource.getParentLogger();
        }

        public XADataSource getDataSource() {
            return this.dataSource;
        }
    }
}

