/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.springmvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.core.ServerResponseWriter;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.springmvc.RequestUtil;
import org.jboss.resteasy.springmvc.ResteasyRequestWrapper;
import org.jboss.resteasy.springmvc.ResteasyWebHandlerTemplate;
import org.jboss.resteasy.util.MediaTypeHelper;
import org.springframework.validation.BindingResult;
import org.springframework.web.servlet.View;

public class ResteasyView
implements View {
    private MediaType contentType = null;
    private List<MediaType> potentialContentTypes = null;
    private ResteasyDeployment deployment;

    public ResteasyView(String contentType, ResteasyDeployment deployment) {
        this.setContentType(contentType);
        this.deployment = deployment;
    }

    public ResteasyView() {
    }

    public ResteasyDeployment getDeployment() {
        return this.deployment;
    }

    public void setDeployment(ResteasyDeployment deployment) {
        this.deployment = deployment;
    }

    public String getContentType() {
        return this.contentType.toString();
    }

    public List<String> getPotentialContentTypes() {
        ArrayList<String> contentTypes = new ArrayList<String>(this.potentialContentTypes.size());
        for (MediaType mediaType : this.potentialContentTypes) {
            contentTypes.add(mediaType.toString());
        }
        return contentTypes;
    }

    public void setPotentialContentTypes(List<String> potentialContentTypes) {
        this.potentialContentTypes = new ArrayList<MediaType>();
        for (String type : potentialContentTypes) {
            this.potentialContentTypes.add(MediaType.valueOf(type));
        }
    }

    public void render(final Map model, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws Exception {
        final SynchronousDispatcher dispatcher = (SynchronousDispatcher)this.deployment.getDispatcher();
        ResteasyWebHandlerTemplate<Void> template = new ResteasyWebHandlerTemplate<Void>(dispatcher.getProviderFactory()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected Void handle(ResteasyRequestWrapper requestWrapper, HttpResponse response) throws Exception {
                HttpRequest httpRequest = requestWrapper.getHttpRequest();
                dispatcher.pushContextObjects(httpRequest, response);
                try {
                    try {
                        MediaType resolvedContentType = ResteasyView.this.resolveContentType(httpRequest, httpRequest.getHttpHeaders().getMediaType());
                        BuiltResponse responseInvoker = ResteasyView.this.getResponse(model, resolvedContentType);
                        if (responseInvoker != null) {
                            ServerResponseWriter.writeNomapResponse(responseInvoker, httpRequest, response, dispatcher.getProviderFactory());
                        }
                    }
                    catch (Exception e) {
                        dispatcher.writeException(httpRequest, response, e);
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    dispatcher.clearContextData();
                }
            }
        };
        ResteasyRequestWrapper requestWrapper = RequestUtil.getRequestWrapper(servletRequest);
        template.handle(requestWrapper, servletResponse);
    }

    private MediaType resolveContentType(HttpRequest jaxrsRequest, MediaType mt) {
        if (mt == null || "*".equals(mt.getType())) {
            List<MediaType> acceptableMediaTypes = jaxrsRequest.getHttpHeaders().getAcceptableMediaTypes();
            if (this.contentType != null && this.isAcceptable(acceptableMediaTypes, this.contentType)) {
                return this.contentType;
            }
            return MediaTypeHelper.getBestMatch(this.potentialContentTypes, acceptableMediaTypes);
        }
        return mt;
    }

    private boolean isAcceptable(List<MediaType> acceptableMediaTypes, MediaType potentialContentType) {
        boolean isAcceptable = false;
        for (MediaType acceptableMediaType : acceptableMediaTypes) {
            if (!acceptableMediaType.isCompatible(potentialContentType)) continue;
            isAcceptable = true;
            break;
        }
        return isAcceptable;
    }

    protected BuiltResponse getResponse(Map model, MediaType mt) {
        Collection modelValues = model.values();
        for (Object value : modelValues) {
            if (!(value instanceof BuiltResponse)) continue;
            return (BuiltResponse)value;
        }
        if (model.size() == 1) {
            return this.createResponse(modelValues.iterator().next(), mt);
        }
        if (model.size() == 2) {
            for (Object value : modelValues) {
                if (value instanceof BindingResult) continue;
                return this.createResponse(value, mt);
            }
        }
        return null;
    }

    private BuiltResponse createResponse(Object value, MediaType contentType) {
        BuiltResponse responseImpl = new BuiltResponse();
        responseImpl.setEntity(value);
        if (contentType != null) {
            responseImpl.getMetadata().putSingle("Content-Type", contentType);
        }
        return responseImpl;
    }

    public void setContentType(String contentType) {
        this.contentType = MediaType.valueOf(contentType);
    }
}

