/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.spring;

import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.PropertyInjector;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.springframework.beans.factory.BeanFactory;

public class SpringResourceFactory
implements ResourceFactory {
    protected BeanFactory beanFactory;
    protected String beanName;
    protected Class<?> scannableClass;
    protected PropertyInjector propertyInjector;
    protected String context = null;

    public SpringResourceFactory(String beanName, BeanFactory beanFactory, Class<?> scannable) {
        this.beanName = beanName;
        this.beanFactory = beanFactory;
        this.scannableClass = scannable;
    }

    public PropertyInjector getPropertyInjector() {
        return this.propertyInjector;
    }

    @Override
    public Object createResource(HttpRequest request, HttpResponse response, ResteasyProviderFactory factory) {
        return this.beanFactory.getBean(this.beanName);
    }

    @Override
    public Class<?> getScannableClass() {
        return this.scannableClass;
    }

    @Override
    public void registered(ResteasyProviderFactory factory) {
        this.propertyInjector = factory.getInjectorFactory().createPropertyInjector(this.getScannableClass(), factory);
    }

    @Override
    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }

    @Override
    public void unregistered() {
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public String getContext() {
        return this.context;
    }
}

