/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class PreMatchContainerRequestContext
implements ContainerRequestContext {
    protected final HttpRequest httpRequest;
    protected Response response;

    public PreMatchContainerRequestContext(HttpRequest request) {
        this.httpRequest = request;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public Response getResponseAbortedWith() {
        return this.response;
    }

    @Override
    public Object getProperty(String name) {
        return this.httpRequest.getAttribute(name);
    }

    @Override
    public Collection<String> getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration<String> enames = this.httpRequest.getAttributeNames();
        while (enames.hasMoreElements()) {
            names.add(enames.nextElement());
        }
        return names;
    }

    @Override
    public void setProperty(String name, Object object) {
        this.httpRequest.setAttribute(name, object);
    }

    @Override
    public void removeProperty(String name) {
        this.httpRequest.removeAttribute(name);
    }

    @Override
    public UriInfo getUriInfo() {
        return this.httpRequest.getUri();
    }

    @Override
    public void setRequestUri(URI requestUri) throws IllegalStateException {
        this.httpRequest.setRequestUri(requestUri);
    }

    @Override
    public void setRequestUri(URI baseUri, URI requestUri) throws IllegalStateException {
        this.httpRequest.setRequestUri(baseUri, requestUri);
    }

    @Override
    public String getMethod() {
        return this.httpRequest.getHttpMethod();
    }

    @Override
    public void setMethod(String method) {
        this.httpRequest.setHttpMethod(method);
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.httpRequest.getHttpHeaders().getRequestHeaders();
    }

    @Override
    public Date getDate() {
        return this.httpRequest.getHttpHeaders().getDate();
    }

    @Override
    public Locale getLanguage() {
        return this.httpRequest.getHttpHeaders().getLanguage();
    }

    @Override
    public int getLength() {
        return this.httpRequest.getHttpHeaders().getLength();
    }

    @Override
    public MediaType getMediaType() {
        return this.httpRequest.getHttpHeaders().getMediaType();
    }

    @Override
    public List<MediaType> getAcceptableMediaTypes() {
        return this.httpRequest.getHttpHeaders().getAcceptableMediaTypes();
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        return this.httpRequest.getHttpHeaders().getAcceptableLanguages();
    }

    @Override
    public Map<String, Cookie> getCookies() {
        return this.httpRequest.getHttpHeaders().getCookies();
    }

    @Override
    public boolean hasEntity() {
        return this.getMediaType() != null;
    }

    @Override
    public InputStream getEntityStream() {
        return this.httpRequest.getInputStream();
    }

    @Override
    public void setEntityStream(InputStream entityStream) {
        this.httpRequest.setInputStream(entityStream);
    }

    @Override
    public SecurityContext getSecurityContext() {
        return ResteasyProviderFactory.getContextData(SecurityContext.class);
    }

    @Override
    public void setSecurityContext(SecurityContext context) {
        ResteasyProviderFactory.pushContext(SecurityContext.class, context);
    }

    @Override
    public Request getRequest() {
        return ResteasyProviderFactory.getContextData(Request.class);
    }

    @Override
    public void abortWith(Response response) {
        this.response = response;
    }

    @Override
    public String getHeaderString(String name) {
        return this.httpRequest.getHttpHeaders().getHeaderString(name);
    }
}

