/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.specimpl.BuiltResponse;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;

public class ContainerResponseContextImpl
implements ContainerResponseContext {
    protected final HttpRequest request;
    protected final HttpResponse httpResponse;
    protected final BuiltResponse jaxrsResponse;

    public ContainerResponseContextImpl(HttpRequest request, HttpResponse httpResponse, BuiltResponse serverResponse) {
        this.request = request;
        this.httpResponse = httpResponse;
        this.jaxrsResponse = serverResponse;
    }

    public BuiltResponse getJaxrsResponse() {
        return this.jaxrsResponse;
    }

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    @Override
    public int getStatus() {
        return this.jaxrsResponse.getStatus();
    }

    @Override
    public void setStatus(int code) {
        this.httpResponse.setStatus(code);
        this.jaxrsResponse.setStatus(code);
    }

    @Override
    public Response.StatusType getStatusInfo() {
        return this.jaxrsResponse.getStatusInfo();
    }

    @Override
    public void setStatusInfo(Response.StatusType statusInfo) {
        this.httpResponse.setStatus(statusInfo.getStatusCode());
        this.jaxrsResponse.setStatus(statusInfo.getStatusCode());
    }

    @Override
    public Class<?> getEntityClass() {
        return this.jaxrsResponse.getEntityClass();
    }

    @Override
    public Type getEntityType() {
        return this.jaxrsResponse.getGenericType();
    }

    @Override
    public void setEntity(Object entity) {
        this.jaxrsResponse.setEntity(entity);
        this.getHeaders().remove("Content-Length");
    }

    @Override
    public void setEntity(Object entity, Annotation[] annotations, MediaType mediaType) {
        this.jaxrsResponse.setEntity(entity);
        this.jaxrsResponse.setAnnotations(annotations);
        this.jaxrsResponse.getHeaders().putSingle("Content-Type", mediaType);
        this.getHeaders().remove("Content-Length");
    }

    @Override
    public MultivaluedMap<String, Object> getHeaders() {
        return this.jaxrsResponse.getMetadata();
    }

    @Override
    public Set<String> getAllowedMethods() {
        return this.jaxrsResponse.getAllowedMethods();
    }

    @Override
    public Date getDate() {
        return this.jaxrsResponse.getDate();
    }

    @Override
    public Locale getLanguage() {
        return this.jaxrsResponse.getLanguage();
    }

    @Override
    public int getLength() {
        return this.jaxrsResponse.getLength();
    }

    @Override
    public MediaType getMediaType() {
        return this.jaxrsResponse.getMediaType();
    }

    @Override
    public Map<String, NewCookie> getCookies() {
        return this.jaxrsResponse.getCookies();
    }

    @Override
    public EntityTag getEntityTag() {
        return this.jaxrsResponse.getEntityTag();
    }

    @Override
    public Date getLastModified() {
        return this.jaxrsResponse.getLastModified();
    }

    @Override
    public URI getLocation() {
        return this.jaxrsResponse.getLocation();
    }

    @Override
    public Set<Link> getLinks() {
        return this.jaxrsResponse.getLinks();
    }

    @Override
    public boolean hasLink(String relation) {
        return this.jaxrsResponse.hasLink(relation);
    }

    @Override
    public Link getLink(String relation) {
        return this.jaxrsResponse.getLink(relation);
    }

    @Override
    public Link.Builder getLinkBuilder(String relation) {
        return this.jaxrsResponse.getLinkBuilder(relation);
    }

    @Override
    public boolean hasEntity() {
        return this.jaxrsResponse.hasEntity();
    }

    @Override
    public Object getEntity() {
        return this.jaxrsResponse.getEntity();
    }

    @Override
    public OutputStream getEntityStream() {
        try {
            return this.httpResponse.getOutputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setEntityStream(OutputStream entityStream) {
        this.httpResponse.setOutputStream(entityStream);
    }

    @Override
    public Annotation[] getEntityAnnotations() {
        return this.jaxrsResponse.getAnnotations();
    }

    @Override
    public MultivaluedMap<String, String> getStringHeaders() {
        return this.jaxrsResponse.getStringHeaders();
    }

    @Override
    public String getHeaderString(String name) {
        return this.jaxrsResponse.getHeaderString(name);
    }
}

