/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.jaxb.JaxbAnnotationModule;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import net.trajano.ms.common.beans.AssertionNotRequiredFunction;
import net.trajano.ms.common.beans.JwtAssertionRequiredPredicate;
import net.trajano.ms.oidc.OpenIdConfiguration;
import net.trajano.ms.oidc.internal.IssuerConfig;
import net.trajano.ms.oidc.internal.IssuersConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;

@Configuration
public class ServiceConfiguration {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private CacheManager cacheManager;
    @Context
    private Client client;
    private Map<String, IssuerConfig> issuers;
    @Value(value="${issuersJson:openidconnect-config.json}")
    private String issuersJson;
    @Value(value="${redirect_uri}")
    private URI redirectUri;
    @Value(value="${token_endpoint:}")
    private URI tokenEndpoint;

    public IssuerConfig getIssuerConfig(String issuerId) {
        return this.issuers.get(issuerId);
    }

    public URI getRedirectUri() {
        return this.redirectUri;
    }

    @PostConstruct
    public void init() throws IOException {
        Resource resource = this.applicationContext.getResource("classpath:" + this.issuersJson);
        if (!resource.exists()) {
            resource = this.applicationContext.getResource("file:" + this.issuersJson);
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule(new JaxbAnnotationModule());
        mapper.readValue(resource.getInputStream(), IssuersConfig.class);
        IssuersConfig issuersConfig = mapper.readValue(resource.getInputStream(), IssuersConfig.class);
        issuersConfig.getIssuers().forEach(issuer -> issuer.setOpenIdConfiguration(this.client.target(UriBuilder.fromUri(issuer.getUri()).path("/.well-known/openid-configuration")).request("application/json").get(OpenIdConfiguration.class)));
        this.issuers = issuersConfig.getIssuers().stream().collect(Collectors.toMap(IssuerConfig::getId, Function.identity()));
        if (this.cacheManager == null) {
            this.cacheManager = new ConcurrentMapCacheManager();
        }
    }

    @Bean
    public JwtAssertionRequiredPredicate noAssertionRequired() {
        return new AssertionNotRequiredFunction();
    }

    @Bean(name={"nonce"})
    public Cache nonceCache() {
        return this.cacheManager.getCache("nonce");
    }
}

