/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.internal;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import io.swagger.annotations.Api;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.ParseException;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.GET;
import javax.ws.rs.InternalServerErrorException;
import javax.ws.rs.NotAuthorizedException;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import net.trajano.ms.common.beans.JwksProvider;
import net.trajano.ms.common.beans.TokenGenerator;
import net.trajano.ms.oidc.OpenIdConfiguration;
import net.trajano.ms.oidc.internal.IssuerConfig;
import net.trajano.ms.oidc.internal.OpenIdToken;
import net.trajano.ms.oidc.internal.ServiceConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.Cache;
import org.springframework.stereotype.Component;

@Api
@Component
@Path(value="/oidc")
public class OpenIdConnectResource {
    @Autowired
    private ClientBuilder cb;
    @Autowired
    private JwksProvider jwksProvider;
    @Autowired
    @Qualifier(value="nonce")
    private Cache nonceCache;
    @Autowired
    private ServiceConfiguration serviceConfiguration;
    @Autowired
    private TokenGenerator tokenGenerator;

    @Path(value="/auth")
    @GET
    public Response auth(@QueryParam(value="state") String state, @QueryParam(value="issuer_id") String issuerId, @Context UriInfo uriInfo) {
        return Response.ok().status(Response.Status.TEMPORARY_REDIRECT).header("Location", this.authUri(state, issuerId, uriInfo)).build();
    }

    @Path(value="/auth-uri")
    @GET
    @Produces(value={"text/plain"})
    public URI authUri(@QueryParam(value="state") String state, @QueryParam(value="issuer_id") String issuerId, @Context UriInfo uriInfo) {
        if (issuerId == null) {
            throw new BadRequestException("Missing issuer_id");
        }
        IssuerConfig issuerConfig = this.serviceConfiguration.getIssuerConfig(issuerId);
        if (issuerConfig == null) {
            throw new BadRequestException("Invalid issuer_id");
        }
        URI redirectUri = UriBuilder.fromUri(this.serviceConfiguration.getRedirectUri()).path(issuerId).build(new Object[0]);
        URI buildAuthenticationRequestUri = issuerConfig.buildAuthenticationRequestUri(redirectUri, state, this.generateNonce(issuerId));
        return buildAuthenticationRequestUri;
    }

    @Path(value="/cb/{issuer_id}")
    @GET
    @Produces(value={"application/json"})
    public Response callback(@QueryParam(value="code") String code, @PathParam(value="issuer_id") String issuerId) throws MalformedURLException, IOException, ParseException, JOSEException {
        RSASSAVerifier verifier;
        JWSObject jws;
        if (issuerId == null) {
            throw new BadRequestException("Missing issuer_id");
        }
        IssuerConfig issuerConfig = this.serviceConfiguration.getIssuerConfig(issuerId);
        if (issuerConfig == null) {
            return Response.ok("Invalid issuer_id").status(Response.Status.BAD_REQUEST).build();
        }
        Client client = this.cb.build();
        URI redirectUri = UriBuilder.fromUri(this.serviceConfiguration.getRedirectUri()).path(issuerId).build(new Object[0]);
        Form form = new Form();
        form.param("redirect_uri", redirectUri.toASCIIString());
        form.param("grant_type", "authorization_code");
        form.param("code", code);
        OpenIdConfiguration openIdConfiguration = issuerConfig.getOpenIdConfiguration();
        OpenIdToken openIdToken = client.target(openIdConfiguration.getTokenEndpoint()).request("application/json").header("Authorization", issuerConfig.buildAuthorization()).buildPost(Entity.form(form)).invoke(OpenIdToken.class);
        JWKSet jwks = JWKSet.load(openIdConfiguration.getJwksUri().toURL());
        JOSEObject joseObject = JOSEObject.parse(openIdToken.getIdToken());
        if (joseObject instanceof JWEObject) {
            JWEObject jwe = (JWEObject)joseObject;
            jwe.decrypt(new RSADecrypter(this.jwksProvider.getDecryptionKey(jwe.getHeader().getKeyID())));
            joseObject = JOSEObject.parse(jwe.getPayload().toString());
        }
        if (joseObject instanceof JWSObject && !(jws = (JWSObject)joseObject).verify(verifier = new RSASSAVerifier(((RSAKey)jwks.getKeyByKeyId(jws.getHeader().getKeyID())).toRSAPublicKey()))) {
            throw new NotAuthorizedException("verification failed", (Object)"JWT", new Object[0]);
        }
        JWTClaimsSet claims = JWTClaimsSet.parse(joseObject.getPayload().toString());
        if (!claims.getAudience().contains(issuerConfig.getClientId())) {
            throw new InternalServerErrorException("client_id mismatch from IP");
        }
        if (!claims.getIssuer().equals(openIdConfiguration.getIssuer())) {
            throw new InternalServerErrorException("issuer mismatch from IP");
        }
        String nonce = claims.getStringClaim("nonce");
        if (!issuerId.equals(this.nonceCache.get((Object)nonce, String.class))) {
            throw new InternalServerErrorException("invalid nonce");
        }
        this.nonceCache.evict(nonce);
        System.out.println(joseObject.getPayload().toString());
        return Response.ok(claims.getSubject()).build();
    }

    private String generateNonce(String issuerId) {
        String nonce = this.tokenGenerator.newToken();
        this.nonceCache.putIfAbsent(nonce, issuerId);
        return nonce;
    }
}

