/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.oidc.internal;

import com.nimbusds.jose.jwk.JWKSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.Base64;
import javax.ws.rs.core.UriBuilder;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import net.trajano.ms.oidc.OpenIdConfiguration;

@XmlRootElement
public class IssuerConfig {
    @XmlElement(name="client_id", required=true)
    private String clientId;
    @XmlElement(name="client_secret", required=true)
    private String clientSecret;
    private String display;
    @XmlElement(required=true)
    private String id;
    @XmlTransient
    private JWKSet jwkset;
    @XmlTransient
    private OpenIdConfiguration openIdConfiguration;
    private String prompt;
    @XmlElement(name="scope", required=true)
    private String scope;
    @XmlElement(required=true)
    private URI uri;

    public URI buildAuthenticationRequestUri(URI redirectUri, String state, String nonce) {
        this.openIdConfiguration.getAuthorizationEndpoint();
        UriBuilder b = UriBuilder.fromUri(this.openIdConfiguration.getAuthorizationEndpoint());
        b.queryParam("response_type", "code");
        b.queryParam("scope", this.scope);
        b.queryParam("client_id", this.clientId);
        b.queryParam("redirect_uri", redirectUri);
        b.queryParam("nonce", nonce);
        if (state != null) {
            b.queryParam("state", state);
        }
        if (this.display != null) {
            b.queryParam("display", this.display);
        }
        if (this.prompt != null) {
            b.queryParam("prompt", this.prompt);
        }
        return b.build(new Object[0]);
    }

    public String buildAuthorization() {
        return "Basic " + Base64.getEncoder().encodeToString((this.clientId + ":" + this.clientSecret).getBytes(StandardCharsets.US_ASCII));
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public String getDisplay() {
        return this.display;
    }

    public String getId() {
        return this.id;
    }

    public JWKSet getJwks() throws MalformedURLException, IOException, ParseException {
        if (this.jwkset == null) {
            this.jwkset = JWKSet.load(this.openIdConfiguration.getJwksUri().toURL());
        }
        return this.jwkset;
    }

    public JWKSet getJwkset() {
        return this.jwkset;
    }

    public OpenIdConfiguration getOpenIdConfiguration() {
        return this.openIdConfiguration;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public String getScope() {
        return this.scope;
    }

    public URI getUri() {
        return this.uri;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setJwkset(JWKSet jwkset) {
        this.jwkset = jwkset;
    }

    public void setOpenIdConfiguration(OpenIdConfiguration openIdConfiguration) {
        this.openIdConfiguration = openIdConfiguration;
    }

    public void setPrompt(String prompt) {
        this.prompt = prompt;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }
}

