/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal.spring;

import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.container.ContainerRequestContext;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.Scope;

public class ContainerRequestScope
implements Scope {
    private final ContainerRequestContext containerRequest;
    private final Map<String, Runnable> destructionCallbacks = new HashMap<String, Runnable>();

    public ContainerRequestScope(ContainerRequestContext containerRequest) {
        this.containerRequest = containerRequest;
    }

    @Override
    public Object get(String name, ObjectFactory<?> objectFactory) {
        Object scopedObject = this.containerRequest.getProperty(name);
        if (scopedObject == null) {
            scopedObject = objectFactory.getObject();
            this.containerRequest.setProperty(name, scopedObject);
        }
        return scopedObject;
    }

    @Override
    public String getConversationId() {
        return this.containerRequest.getRequest().toString();
    }

    @Override
    public void registerDestructionCallback(String name, Runnable callback) {
        this.destructionCallbacks.put(name, callback);
    }

    @Override
    public Object remove(String name) {
        Object scopedObject = this.containerRequest.getProperty(name);
        if (scopedObject != null) {
            this.containerRequest.removeProperty(name);
            this.destructionCallbacks.remove(name);
            return scopedObject;
        }
        return null;
    }

    @Override
    public Object resolveContextualObject(String key) {
        return "request";
    }
}

