/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal.resteasy;

import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.OutputStream;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import net.trajano.ms.engine.internal.Conversions;
import net.trajano.ms.engine.internal.VertxOutputStream;
import net.trajano.ms.engine.internal.resteasy.VertxOutputHeaders;
import org.jboss.resteasy.spi.HttpResponse;

public class VertxHttpResponse
implements HttpResponse {
    private final RoutingContext context;
    private OutputStream os;
    private final MultivaluedMap<String, Object> outputHeaders;
    private final HttpServerResponse vertxResponse;

    public VertxHttpResponse(RoutingContext context) {
        this.context = context;
        this.vertxResponse = context.response();
        this.os = new VertxOutputStream(this.vertxResponse);
        this.outputHeaders = new VertxOutputHeaders(this.vertxResponse);
    }

    @Override
    public void addNewCookie(NewCookie cookie) {
        this.context.addCookie(Conversions.toVertxCookie(cookie));
    }

    @Override
    public MultivaluedMap<String, Object> getOutputHeaders() {
        return this.outputHeaders;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.os;
    }

    @Override
    public int getStatus() {
        return this.vertxResponse.getStatusCode();
    }

    @Override
    public boolean isCommitted() {
        return this.vertxResponse.headWritten();
    }

    @Override
    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response is committed");
        }
        this.setStatus(200);
        this.vertxResponse.headers().clear();
    }

    @Override
    public void sendError(int status) throws IOException {
        this.sendError(status, Response.Status.fromStatusCode(status).getReasonPhrase());
    }

    @Override
    public void sendError(int status, String message) throws IOException {
        this.vertxResponse.setStatusCode(status);
        this.vertxResponse.setStatusMessage(message);
    }

    @Override
    public void setOutputStream(OutputStream os) {
        this.os = os;
    }

    @Override
    public void setStatus(int status) {
        this.vertxResponse.setStatusCode(status);
        this.vertxResponse.setStatusMessage(Response.Status.fromStatusCode(status).getReasonPhrase());
    }
}

