/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal.resteasy;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.io.InputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MultivaluedMap;
import net.trajano.ms.engine.internal.Conversions;
import net.trajano.ms.engine.internal.NullInputStream;
import net.trajano.ms.engine.internal.VertxBlockingInputStream;
import net.trajano.ms.engine.internal.resteasy.VertxExecutionContext;
import net.trajano.ms.engine.internal.resteasy.VertxHttpResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.plugins.server.BaseHttpRequest;
import org.jboss.resteasy.specimpl.ResteasyHttpHeaders;
import org.jboss.resteasy.spi.ResteasyAsynchronousContext;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxHttpRequest
extends BaseHttpRequest {
    private static final Logger LOG = LoggerFactory.getLogger(VertxHttpRequest.class);
    private final ResteasyAsynchronousContext asynchronousContext;
    private final Map<String, Object> attributes;
    private boolean forwarded;
    private final ResteasyHttpHeaders httpHeaders;
    private final InputStream is;
    private final HttpServerRequest vertxRequest;

    public VertxHttpRequest(RoutingContext context, ResteasyUriInfo uriInfo, SynchronousDispatcher dispatcher) {
        super(uriInfo);
        this.vertxRequest = context.request();
        LOG.debug("vertxRequest.isEnded={}", (Object)this.vertxRequest.isEnded());
        if (!this.vertxRequest.isEnded()) {
            VertxBlockingInputStream is = new VertxBlockingInputStream(this.vertxRequest);
            this.is = is;
        } else {
            this.is = NullInputStream.nullInputStream();
        }
        this.httpHeaders = new ResteasyHttpHeaders(Conversions.toMultivaluedStringMap(this.vertxRequest.headers()), Conversions.toCookies(context.cookies()));
        this.attributes = new HashMap<String, Object>();
        this.asynchronousContext = new VertxExecutionContext(context, dispatcher, this, new VertxHttpResponse(context));
    }

    @Override
    public void forward(String path) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ResteasyAsynchronousContext getAsyncContext() {
        return this.asynchronousContext;
    }

    @Override
    public Object getAttribute(String attribute) {
        return this.attributes.get(attribute);
    }

    @Override
    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    @Override
    public HttpHeaders getHttpHeaders() {
        return this.httpHeaders;
    }

    @Override
    public String getHttpMethod() {
        return this.vertxRequest.method().name();
    }

    @Override
    public InputStream getInputStream() {
        return this.is;
    }

    @Override
    public MultivaluedMap<String, String> getMutableHeaders() {
        return this.httpHeaders.getMutableHeaders();
    }

    @Override
    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public void setHttpMethod(String method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean wasForwarded() {
        return this.forwarded;
    }
}

