/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal.resteasy;

import io.vertx.ext.web.RoutingContext;
import java.util.concurrent.TimeUnit;
import net.trajano.ms.engine.internal.resteasy.VertxAsynchronousResponse;
import net.trajano.ms.engine.internal.resteasy.VertxHttpResponse;
import org.jboss.resteasy.core.AbstractExecutionContext;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.ResteasyAsynchronousResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxExecutionContext
extends AbstractExecutionContext {
    private static final Logger LOG = LoggerFactory.getLogger(VertxExecutionContext.class);
    private VertxAsynchronousResponse asynchronousResponse;
    private final RoutingContext routingContext;
    private final VertxHttpResponse vertxResponse;

    public VertxExecutionContext(RoutingContext routingContext, SynchronousDispatcher dispatcher, HttpRequest request, VertxHttpResponse response) {
        super(dispatcher, request, response);
        this.routingContext = routingContext;
        this.vertxResponse = response;
    }

    @Override
    public ResteasyAsynchronousResponse getAsyncResponse() {
        return this.asynchronousResponse;
    }

    @Override
    public boolean isSuspended() {
        return this.asynchronousResponse != null;
    }

    @Override
    public ResteasyAsynchronousResponse suspend() {
        this.asynchronousResponse = new VertxAsynchronousResponse(this.dispatcher, this.request, this.vertxResponse, this.routingContext);
        LOG.debug("asynchronousResponse={} created", (Object)this.asynchronousResponse);
        return this.asynchronousResponse;
    }

    @Override
    public ResteasyAsynchronousResponse suspend(long millis) {
        return this.suspend(millis, TimeUnit.MILLISECONDS);
    }

    @Override
    public ResteasyAsynchronousResponse suspend(long time, TimeUnit unit) {
        this.asynchronousResponse = new VertxAsynchronousResponse(this.dispatcher, this.request, this.vertxResponse, this.routingContext);
        LOG.debug("asynchronousResponse={} created", (Object)this.asynchronousResponse);
        this.asynchronousResponse.setTimeout(time, unit);
        return this.asynchronousResponse;
    }
}

