/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal.resteasy;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Semaphore;
import javax.ws.rs.core.MediaType;
import net.trajano.ms.engine.internal.Conversions;
import net.trajano.ms.engine.internal.VertxBlockingInputStream;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ClientResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxClientResponse
extends ClientResponse {
    private static final Logger LOG = LoggerFactory.getLogger(VertxClientResponse.class);
    private final VertxBlockingInputStream is;
    private final Semaphore metadataLock = new Semaphore(0);

    public VertxClientResponse(ClientConfiguration configuration, HttpClientRequest httpClientRequest) {
        super(configuration);
        this.is = new VertxBlockingInputStream();
        httpClientRequest.handler(httpClientResponse -> {
            this.setStatus(httpClientResponse.statusCode());
            this.setHeaders(Conversions.toMultivaluedStringMap(httpClientResponse.headers()));
            httpClientResponse.handler(buffer -> this.is.populate((Buffer)buffer)).endHandler(aVoid -> this.is.end());
            LOG.trace("prepared HTTP client response handler");
            this.metadataLock.release();
        }).exceptionHandler(e -> {
            this.is.error((Throwable)e);
            this.metadataLock.release();
        });
        LOG.trace("prepared HTTP client request handler");
    }

    @Override
    protected InputStream getInputStream() {
        LOG.trace("inputStream={}", (Object)this.is);
        return this.is;
    }

    @Override
    public MediaType getMediaType() {
        this.metadataLock.acquireUninterruptibly();
        return super.getMediaType();
    }

    @Override
    public void releaseConnection() throws IOException {
        LOG.debug("connection released");
    }

    @Override
    protected void setInputStream(InputStream is) {
        throw new UnsupportedOperationException();
    }
}

