/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal.resteasy;

import io.vertx.ext.web.RoutingContext;
import java.util.Date;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.ws.rs.core.Response;
import net.trajano.ms.engine.internal.resteasy.VertxHttpResponse;
import org.jboss.resteasy.core.AbstractAsynchronousResponse;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.spi.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxAsynchronousResponse
extends AbstractAsynchronousResponse {
    private static final Logger LOG = LoggerFactory.getLogger(VertxAsynchronousResponse.class);
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final RoutingContext routingContext;
    private final AtomicBoolean suspended = new AtomicBoolean(true);
    private long timeoutTimerID = -1L;
    private final Semaphore writeLock = new Semaphore(1);

    public VertxAsynchronousResponse(SynchronousDispatcher dispatcher, HttpRequest request, VertxHttpResponse response, RoutingContext routingContext) {
        super(dispatcher, request, response);
        this.routingContext = routingContext;
    }

    @Override
    public boolean cancel() {
        if (this.cancelled.getAndSet(true)) {
            return false;
        }
        return this.sendData(Response.ok(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase()).status(Response.Status.SERVICE_UNAVAILABLE).build());
    }

    @Override
    public boolean cancel(Date retryAfter) {
        if (this.cancelled.getAndSet(true)) {
            return false;
        }
        return this.sendData(Response.ok(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase()).header("Retry-After", retryAfter).status(Response.Status.SERVICE_UNAVAILABLE).build());
    }

    @Override
    public boolean cancel(int retryAfter) {
        if (this.cancelled.getAndSet(true)) {
            return false;
        }
        return this.sendData(Response.ok(Response.Status.SERVICE_UNAVAILABLE.getReasonPhrase()).header("Retry-After", retryAfter).status(Response.Status.SERVICE_UNAVAILABLE).build());
    }

    private void handleTimeout() {
        LOG.warn("Timeout has occurred for timerId={}", (Object)this.timeoutTimerID);
        this.timeoutTimerID = -1L;
        if (this.timeoutHandler != null) {
            this.timeoutHandler.handleTimeout(this);
        }
    }

    @Override
    public void initialRequestThreadFinished() {
        LOG.debug("initialRequestThreadFinished");
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled.get();
    }

    @Override
    public boolean isDone() {
        return this.done.get();
    }

    @Override
    public boolean isSuspended() {
        return this.suspended.get();
    }

    @Override
    public boolean resume(Object response) {
        LOG.debug("Object response received={}", response);
        return this.sendData(response);
    }

    @Override
    public boolean resume(Throwable response) {
        LOG.debug("Throwable response received={}", response);
        return this.sendData(response);
    }

    private boolean sendData(Object entity) {
        if (!this.suspended.getAndSet(false)) {
            return false;
        }
        try {
            if (!this.writeLock.tryAcquire()) {
                LOG.error("Semaphore locked", (Object)this.timeoutTimerID);
                this.writeLock.acquire();
            }
            this.internalResume(entity);
            this.done.set(true);
            if (this.timeoutTimerID != -1L && !this.routingContext.vertx().cancelTimer(this.timeoutTimerID)) {
                LOG.error("Attempted to cancel a timer that does not exist {}", (Object)this.timeoutTimerID);
            }
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.release();
        }
    }

    @Override
    public boolean setTimeout(long time, TimeUnit unit) {
        try {
            this.writeLock.acquire();
            if (!this.isSuspended()) {
                boolean bl = false;
                return bl;
            }
            if (this.timeoutTimerID != -1L && !this.routingContext.vertx().cancelTimer(this.timeoutTimerID)) {
                LOG.error("Attempted to cancel a timer that does not exist {}", (Object)this.timeoutTimerID);
            }
            long millis = unit.toMillis(time);
            this.timeoutTimerID = this.routingContext.vertx().setTimer(millis, timerId -> this.handleTimeout());
            LOG.debug("New timeout handler created timeoutTimerId={} for {} ms", (Object)this.timeoutTimerID, (Object)millis);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        finally {
            this.writeLock.release();
        }
    }
}

