/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.streams.WriteStream;
import java.io.IOException;
import java.io.OutputStream;

public class VertxOutputStream
extends OutputStream {
    private final WriteStream<Buffer> stream;

    public VertxOutputStream(WriteStream<Buffer> stream) {
        this.stream = stream;
    }

    private void addChunkedIfNeeded() {
        HttpClientRequest req;
        if (this.stream instanceof HttpServerResponse) {
            HttpServerResponse resp = (HttpServerResponse)this.stream;
            if (resp.headers().get(HttpHeaders.CONTENT_LENGTH) == null) {
                resp.setChunked(true);
            }
        } else if (this.stream instanceof HttpClientRequest && (req = (HttpClientRequest)this.stream).headers().get(HttpHeaders.CONTENT_LENGTH) == null) {
            req.setChunked(true);
        }
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.addChunkedIfNeeded();
        this.stream.write(Buffer.buffer(b));
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.addChunkedIfNeeded();
        this.stream.write(Buffer.buffer().appendBytes(b, off, len));
    }

    @Override
    public void write(int b) throws IOException {
        this.addChunkedIfNeeded();
        Buffer buffer = Buffer.buffer(new byte[]{(byte)b});
        this.stream.write(buffer);
    }
}

