/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal;

import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.InputStream;

public class VertxBufferInputStream
extends InputStream {
    private final Buffer buffer;
    private int pos;

    public VertxBufferInputStream(Buffer buffer) {
        this.buffer = buffer;
        this.pos = 0;
    }

    @Override
    public int read() throws IOException {
        if (this.pos == this.buffer.length()) {
            return -1;
        }
        return this.buffer.getByte(this.pos++);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int size = Math.min(b.length, this.buffer.length() - this.pos);
        if (size == 0) {
            return -1;
        }
        this.buffer.getBytes(this.pos, this.pos + size, b, off);
        this.pos += size;
        return size;
    }
}

