/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine.internal;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.RequestOptions;
import io.vertx.ext.web.Cookie;
import io.vertx.ext.web.impl.CookieImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;

public final class Conversions {
    public static Buffer toBuffer(InputStream is) throws IOException {
        int len;
        Buffer b = Buffer.buffer(1024);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) >= 0) {
            b.appendBytes(buf, 0, len);
        }
        return b;
    }

    public static javax.ws.rs.core.Cookie toCookie(Cookie vertxCookie) {
        return new javax.ws.rs.core.Cookie(vertxCookie.getName(), vertxCookie.getValue(), vertxCookie.getPath(), vertxCookie.getDomain());
    }

    public static Map<String, javax.ws.rs.core.Cookie> toCookies(Set<Cookie> vertxCookies) {
        HashMap<String, javax.ws.rs.core.Cookie> cookies = new HashMap<String, javax.ws.rs.core.Cookie>(vertxCookies.size());
        vertxCookies.forEach(vertxCookie -> cookies.put(vertxCookie.getName(), Conversions.toCookie(vertxCookie)));
        return cookies;
    }

    public static MultivaluedMap<String, Object> toMultivaluedMap(MultiMap multimap) {
        MultivaluedHashMap<String, Object> mvm = new MultivaluedHashMap<String, Object>(multimap.size());
        multimap.forEach(entry -> mvm.add((String)entry.getKey(), entry.getValue()));
        return mvm;
    }

    public static MultivaluedMap<String, String> toMultivaluedStringMap(MultiMap multimap) {
        MultivaluedHashMap<String, String> mvm = new MultivaluedHashMap<String, String>(multimap.size());
        multimap.forEach(entry -> mvm.add((String)entry.getKey(), (String)entry.getValue()));
        return mvm;
    }

    public static RequestOptions toRequestOptions(URI uri) {
        RequestOptions options = new RequestOptions().setSsl("https".equals(uri.getScheme())).setHost(uri.getHost());
        if (uri.getPort() > 0) {
            options.setPort(uri.getPort());
        } else if (options.isSsl()) {
            options.setPort(443);
        } else {
            options.setPort(80);
        }
        if (uri.getRawQuery() == null) {
            options.setURI(uri.getRawPath());
        } else {
            options.setURI(uri.getRawPath() + "?" + uri.getRawQuery());
        }
        return options;
    }

    public static Cookie toVertxCookie(NewCookie cookie) {
        CookieImpl vertxCookie = new CookieImpl(cookie.getName(), cookie.getValue());
        vertxCookie.setPath(cookie.getPath());
        vertxCookie.setDomain(cookie.getDomain());
        vertxCookie.setHttpOnly(cookie.isHttpOnly());
        vertxCookie.setChanged(true);
        vertxCookie.setMaxAge(cookie.getMaxAge());
        vertxCookie.setSecure(cookie.isSecure());
        return vertxCookie;
    }
}

