/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.swagger.annotations.Api;
import io.swagger.annotations.SwaggerDefinition;
import io.swagger.jaxrs.Reader;
import io.swagger.util.Json;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.core.Application;
import net.trajano.ms.engine.internal.swagger.ClonableSwagger;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;

public class SwaggerHandler
implements Handler<RoutingContext>,
AutoCloseable {
    private final URI baseUri;
    private final ClonableSwagger swagger;

    @SafeVarargs
    public static SwaggerHandler[] multipleRegisterToRouter(Router router, Class<? extends Application> ... applicationClasses) {
        SwaggerHandler[] ret = new SwaggerHandler[applicationClasses.length];
        int i = 0;
        for (Class<? extends Application> applicationClass : applicationClasses) {
            SwaggerHandler requestHandler = new SwaggerHandler(applicationClass);
            router.route(requestHandler.baseUriRoute()).useNormalisedPath(true).handler(requestHandler);
            ret[i++] = requestHandler;
        }
        return ret;
    }

    public static SwaggerHandler registerToRouter(Router router, Class<? extends Application> applicationClass) {
        return SwaggerHandler.multipleRegisterToRouter(router, applicationClass)[0];
    }

    public SwaggerHandler(Class<? extends Application> applicationClass) {
        Application application;
        ApplicationPath annotation = applicationClass.getAnnotation(ApplicationPath.class);
        this.baseUri = annotation != null ? URI.create(annotation.value()).normalize() : URI.create("/");
        try {
            application = applicationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExceptionInInitializerError(e);
        }
        this.swagger = new ClonableSwagger();
        Reader swaggerReader = new Reader(this.swagger);
        Set<Class<?>> resourceClasses = application.getClasses();
        if (resourceClasses.isEmpty()) {
            String packageName = applicationClass.getPackage().getName();
            Reflections reflections = new Reflections(packageName, new Scanner[0]);
            reflections.getTypesAnnotatedWith(Api.class).forEach(clazz -> swaggerReader.read((Class<?>)clazz));
            reflections.getTypesAnnotatedWith(SwaggerDefinition.class).forEach(clazz -> swaggerReader.read((Class<?>)clazz));
        } else {
            swaggerReader.read(applicationClass);
            resourceClasses.forEach(clazz -> swaggerReader.read((Class<?>)clazz));
        }
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public String baseUriRoute() {
        return this.baseUri().getPath();
    }

    @Override
    public void close() {
    }

    @Override
    public void handle(RoutingContext context) {
        try {
            context.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/json").end(Buffer.buffer(Json.mapper().writeValueAsBytes(this.swagger.withRoutingContext(context))));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

