/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.Set;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Path;
import javax.ws.rs.client.Client;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.trajano.ms.engine.internal.VertxRequestContextFilter;
import net.trajano.ms.engine.internal.resteasy.VertxClientEngine;
import net.trajano.ms.engine.internal.resteasy.VertxHttpRequest;
import net.trajano.ms.engine.internal.resteasy.VertxHttpResponse;
import net.trajano.ms.engine.internal.spring.SpringConfiguration;
import net.trajano.ms.engine.jaxrs.VertxJsonProvider;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.spring.SpringBeanProcessor;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.spi.ResteasyUriInfo;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;

public class SpringJaxRsHandler
implements Handler<RoutingContext>,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SpringJaxRsHandler.class);
    private final AnnotationConfigApplicationContext applicationContext;
    private final URI baseUri;
    private final ResteasyDeployment deployment;
    private final SynchronousDispatcher dispatcher;
    private HttpClientOptions httpClientOptions;
    private final ResteasyProviderFactory providerFactory;

    @SafeVarargs
    public static SpringJaxRsHandler[] multipleRegisterToRouter(Router router, Class<? extends Application> ... applicationClasses) {
        return SpringJaxRsHandler.multipleRegisterToRouter(router, null, applicationClasses);
    }

    @SafeVarargs
    public static SpringJaxRsHandler[] multipleRegisterToRouter(Router router, ConfigurableApplicationContext baseApplicationContext, Class<? extends Application> ... applicationClasses) {
        SpringJaxRsHandler[] ret = new SpringJaxRsHandler[applicationClasses.length];
        int i = 0;
        for (Class<? extends Application> applicationClass : applicationClasses) {
            SpringJaxRsHandler requestHandler = new SpringJaxRsHandler(baseApplicationContext, applicationClass);
            router.route(requestHandler.baseUriRoute()).useNormalisedPath(true).handler(requestHandler);
            ret[i++] = requestHandler;
            LOG.debug("Route to {} handled by {}", (Object)requestHandler.baseUriRoute(), (Object)requestHandler);
        }
        return ret;
    }

    public static SpringJaxRsHandler registerToRouter(Router router, Class<? extends Application> applicationClass) {
        return SpringJaxRsHandler.multipleRegisterToRouter(router, applicationClass)[0];
    }

    public static SpringJaxRsHandler registerToRouter(Router router, ConfigurableApplicationContext applicationContext, Class<? extends Application> applicationClass) {
        return SpringJaxRsHandler.multipleRegisterToRouter(router, applicationContext, applicationClass)[0];
    }

    public SpringJaxRsHandler(Class<? extends Application> applicationClass) {
        this(null, applicationClass);
    }

    public SpringJaxRsHandler(ConfigurableApplicationContext baseApplicationContext, Class<? extends Application> applicationClass) {
        Application application;
        if (baseApplicationContext == null) {
            LOG.debug("baseApplicationContext={} is null, a new application context will be created.");
            this.applicationContext = new AnnotationConfigApplicationContext();
        } else if (baseApplicationContext.isActive()) {
            LOG.debug("baseApplicationContext={} is active, will use as parent.");
            this.applicationContext = new AnnotationConfigApplicationContext();
            this.applicationContext.setParent(baseApplicationContext);
        } else if (!(baseApplicationContext instanceof AnnotationConfigApplicationContext)) {
            LOG.debug("baseApplicationContext={} is not active, but is not an instance of AnnotationConfigApplicationContext, will activate and use as parent.");
            baseApplicationContext.refresh();
            this.applicationContext = new AnnotationConfigApplicationContext();
            this.applicationContext.setParent(baseApplicationContext);
        } else {
            LOG.debug("baseApplicationContext={} is not active, will reuse.");
            this.applicationContext = (AnnotationConfigApplicationContext)baseApplicationContext;
        }
        this.applicationContext.register(SpringConfiguration.class, applicationClass, VertxRequestContextFilter.class, VertxJsonProvider.class);
        ApplicationPath annotation = applicationClass.getAnnotation(ApplicationPath.class);
        this.baseUri = annotation != null ? URI.create(annotation.value() + "").normalize() : URI.create("");
        try {
            application = applicationClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ExceptionInInitializerError(e);
        }
        Set<Class<?>> resourceClasses = application.getClasses();
        if (resourceClasses.isEmpty()) {
            String packageName = applicationClass.getPackage().getName();
            LOG.debug("getClasses() is empty, performing scanning of annotated JAX-RS classes from {}", (Object)packageName);
            Reflections reflections = new Reflections(packageName, new Scanner[0]);
            reflections.getTypesAnnotatedWith(Path.class).forEach(clazz -> {
                LOG.debug("{} => @Path {}", (Object)(this.baseUri + clazz.getAnnotation(Path.class).value()), clazz);
                this.applicationContext.register((Class<?>)clazz);
            });
            reflections.getTypesAnnotatedWith(Provider.class).forEach(clazz -> this.applicationContext.register((Class<?>)clazz));
        } else {
            LOG.debug("getClasses() = {}, not performing any scan", (Object)resourceClasses);
            resourceClasses.forEach(clazz -> this.applicationContext.register((Class<?>)clazz));
        }
        this.deployment = new ResteasyDeployment();
        this.deployment.setApplication(application);
        this.deployment.start();
        SpringBeanProcessor springBeanProcessor = new SpringBeanProcessor(this.deployment);
        this.applicationContext.addBeanFactoryPostProcessor(springBeanProcessor);
        this.applicationContext.addApplicationListener(springBeanProcessor);
        this.applicationContext.refresh();
        if (baseApplicationContext != null) {
            baseApplicationContext.getBeansWithAnnotation(Provider.class).forEach((name, obj) -> {
                if (!this.deployment.getProviderFactory().isRegistered(obj)) {
                    LOG.debug("registering {} into provider factory", name);
                    this.deployment.getProviderFactory().register(obj);
                }
            });
        }
        this.httpClientOptions = this.applicationContext.getBean(HttpClientOptions.class);
        if (this.httpClientOptions == null) {
            this.httpClientOptions = new HttpClientOptions();
        }
        this.deployment.start();
        this.dispatcher = (SynchronousDispatcher)this.deployment.getDispatcher();
        this.providerFactory = this.deployment.getProviderFactory();
    }

    public URI baseUri() {
        return this.baseUri;
    }

    public String baseUriRoute() {
        return this.baseUri().toASCIIString() + "/*";
    }

    @Override
    public void close() {
        this.deployment.stop();
        this.applicationContext.close();
    }

    @Override
    public void handle(RoutingContext context) {
        Client client = this.jaxRsClient(context.vertx());
        HttpServerRequest serverRequest = context.request();
        ResteasyUriInfo uriInfo = new ResteasyUriInfo(serverRequest.uri(), serverRequest.query(), this.baseUri.toASCIIString());
        VertxHttpRequest request = new VertxHttpRequest(context, uriInfo, this.dispatcher);
        try (VertxHttpResponse response = new VertxHttpResponse(context);){
            context.vertx().executeBlocking(future -> {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("{} {}", (Object)context.request().method(), (Object)serverRequest.absoluteURI());
                }
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
                ResteasyProviderFactory.pushContext(RoutingContext.class, context);
                ResteasyProviderFactory.pushContext(Vertx.class, context.vertx());
                ResteasyProviderFactory.pushContext(Client.class, client);
                try {
                    this.dispatcher.invokePropagateNotFound(request, response);
                    future.complete();
                }
                finally {
                    ResteasyProviderFactory.clearContextData();
                    ThreadLocalResteasyProviderFactory.pop();
                }
            }, false, res -> {
                if (res.failed()) {
                    Throwable wae = res.cause();
                    if (wae instanceof NotFoundException) {
                        LOG.debug("uri={} was not found", (Object)serverRequest.uri());
                        context.response().setStatusCode(404);
                        context.response().setStatusMessage(Response.Status.NOT_FOUND.getReasonPhrase());
                        if (context.request().method() != HttpMethod.HEAD) {
                            context.response().putHeader("Content-Type", "text/plain");
                            context.response().end(wae.getLocalizedMessage());
                        }
                    } else {
                        LOG.error(wae.getMessage(), wae);
                        context.response().setStatusCode(500);
                        context.response().setStatusMessage(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
                        if (context.request().method() != HttpMethod.HEAD) {
                            context.response().putHeader("Content-Type", "text/plain");
                            context.response().end(Response.Status.INTERNAL_SERVER_ERROR.getReasonPhrase());
                        }
                    }
                } else if (!context.response().ended()) {
                    context.response().end();
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private Client jaxRsClient(Vertx vertx) {
        Client jaxRsClient = (Client)vertx.getOrCreateContext().get(Client.class.getName());
        if (jaxRsClient == null) {
            HttpClient httpClient = vertx.createHttpClient(this.httpClientOptions);
            jaxRsClient = new ResteasyClientBuilder().providerFactory(this.providerFactory).httpEngine(new VertxClientEngine(httpClient)).build();
            vertx.getOrCreateContext().put(Client.class.getName(), jaxRsClient);
        }
        return jaxRsClient;
    }
}

