/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.engine;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.jar.Manifest;
import net.trajano.ms.engine.internal.BufferUtil;
import net.trajano.ms.engine.internal.VertxBufferInputStream;

public class ManifestHandler
implements Handler<RoutingContext>,
AutoCloseable {
    private final Buffer json;
    private final Buffer text;

    public static ManifestHandler registerToRouter(Router router) {
        return ManifestHandler.registerToRouter(router, "/.well-known/manifest");
    }

    public static ManifestHandler registerToRouter(Router router, String uri) {
        ManifestHandler requestHandler = new ManifestHandler();
        router.get(uri).handler(requestHandler);
        return requestHandler;
    }

    public ManifestHandler() {
        try {
            this.text = BufferUtil.bufferFromClasspathResource("META-INF/MANIFEST.MF");
            Manifest mf = new Manifest(new VertxBufferInputStream(this.text));
            JsonObject mapFrom = JsonObject.mapFrom(mf.getMainAttributes());
            this.json = mapFrom.toBuffer();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public void close() throws Exception {
    }

    @Override
    public void handle(RoutingContext context) {
        if ("text/plain".equals(context.getAcceptableContentType())) {
            context.response().putHeader("Content-Type", "text/plain").end(this.text);
        } else {
            context.response().putHeader("Content-Type", "application/json").end(this.json);
        }
    }
}

