/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common.jaxrs;

import com.nimbusds.jwt.JWTClaimsSet;
import java.security.Principal;
import java.text.ParseException;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import net.trajano.ms.common.IdTokenPrincipal;

public class JwtSecurityContext
implements SecurityContext {
    private final IdTokenPrincipal principal;
    private final Set<String> roles;
    private final boolean secure;

    public JwtSecurityContext(JWTClaimsSet claimsSet, UriInfo uriInfo) {
        this.principal = new IdTokenPrincipal(claimsSet);
        this.secure = "https".equals(uriInfo.getRequestUri().getScheme());
        try {
            String[] claimRoles = this.principal.getClaimsSet().getStringArrayClaim("roles");
            this.roles = claimRoles == null ? Collections.emptySet() : Stream.of(claimRoles).collect(Collectors.toSet());
        }
        catch (ParseException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    @Override
    public String getAuthenticationScheme() {
        return "X-JWT-Assertion";
    }

    @Override
    public Principal getUserPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }
}

