/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common.jaxrs;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JOSEObject;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.JWSObject;
import com.nimbusds.jose.crypto.RSADecrypter;
import com.nimbusds.jose.crypto.RSASSAVerifier;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.text.ParseException;
import java.util.concurrent.ExecutionException;
import javax.annotation.PostConstruct;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import net.trajano.ms.common.beans.DefaultAssertionRequiredFunction;
import net.trajano.ms.common.beans.JwksProvider;
import net.trajano.ms.common.beans.JwtAssertionRequiredPredicate;
import net.trajano.ms.common.beans.JwtClaimsProcessor;
import net.trajano.ms.common.jaxrs.JwtSecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Provider
public class JwtAssertionInterceptor
implements ContainerRequestFilter {
    private static final Logger LOG = LoggerFactory.getLogger(JwtAssertionInterceptor.class);
    private JwtAssertionRequiredPredicate assertionRequiredPredicate;
    @Autowired(required=false)
    @Qualifier(value="authz.audience")
    private URI audience;
    private JwtClaimsProcessor claimsProcessor;
    @Autowired(required=false)
    @Qualifier(value="authz.issuer")
    private URI issuer;
    private JwksProvider jwksProvider;
    private Cache<String, RSAKey> keyCache;
    private final long MAX_NUMBER_OF_KEYS = 20L;
    @Context
    private ResourceInfo resourceInfo;
    @Autowired(required=false)
    @Qualifier(value="authz.signature.jwks.uri")
    private URI signatureJwksUri;

    @Override
    public void filter(ContainerRequestContext requestContext) throws IOException {
        JWTClaimsSet claims;
        if (!this.assertionRequiredPredicate.test(this.resourceInfo)) {
            return;
        }
        String assertion = requestContext.getHeaderString("X-JWT-Assertion");
        if (assertion == null) {
            LOG.warn("Missing assertion on request for {}", (Object)requestContext.getUriInfo());
            requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).header("WWW-Authenticate", "JWT").entity("missing assertion").build());
            return;
        }
        LOG.debug("assertion={}", (Object)assertion);
        try {
            JOSEObject joseObject = JOSEObject.parse(assertion);
            if (joseObject instanceof JWEObject) {
                JWEObject jwe = (JWEObject)joseObject;
                jwe.decrypt(new RSADecrypter(this.jwksProvider.getDecryptionKey(jwe.getHeader().getKeyID())));
                joseObject = JOSEObject.parse(jwe.getPayload().toString());
            }
            if (joseObject instanceof JWSObject) {
                RSASSAVerifier verifier;
                JWSObject jws = (JWSObject)joseObject;
                if (this.signatureJwksUri != null && !jws.verify(verifier = new RSASSAVerifier(this.getSigningKey(jws.getHeader().getKeyID())))) {
                    LOG.warn("JWT verification failed for {}", (Object)requestContext.getUriInfo());
                    requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).header("WWW-Authenticate", "JWT").entity("signature vertification failed").build());
                    return;
                }
            }
            claims = JWTClaimsSet.parse(joseObject.getPayload().toString());
        }
        catch (JOSEException | ParseException | ExecutionException e) {
            throw new BadRequestException("unable to parse JWT");
        }
        if (this.audience != null && !claims.getAudience().contains(this.audience.toASCIIString())) {
            LOG.warn("Audience {} did not match {} for {}", claims.getAudience(), this.audience, requestContext.getUriInfo());
            requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).header("WWW-Authenticate", "JWT").entity("audience vertification failed").build());
            return;
        }
        if (this.issuer != null && !claims.getIssuer().equals(this.issuer.toASCIIString())) {
            LOG.warn("Issuer {} did not match {} for {}", claims.getIssuer(), this.issuer, requestContext.getUriInfo());
            requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).header("WWW-Authenticate", "JWT").entity("issuer vertification failed").build());
            return;
        }
        if (claims.getExpirationTime() != null && claims.getExpirationTime().after(requestContext.getDate())) {
            LOG.warn("Claims expired for {}", (Object)requestContext.getUriInfo());
            requestContext.abortWith(Response.status(Response.Status.UNAUTHORIZED).header("WWW-Authenticate", "JWT").entity("claims expired").build());
            return;
        }
        requestContext.setSecurityContext(new JwtSecurityContext(claims, requestContext.getUriInfo()));
        if (this.claimsProcessor != null) {
            boolean validateClaims = (Boolean)this.claimsProcessor.apply(claims);
            LOG.debug("{}.validateClaims result={}", (Object)this.claimsProcessor, (Object)validateClaims);
            if (!validateClaims) {
                LOG.warn("Validation of claims failed on request for {}", (Object)requestContext.getUriInfo());
                requestContext.abortWith(Response.status(Response.Status.FORBIDDEN).entity("claims validation failed").build());
            }
        }
    }

    private RSAKey getSigningKey(String keyId) throws ExecutionException {
        RSAKey key = this.keyCache.get(keyId, () -> {
            JWKSet signatureJwks = JWKSet.load(this.signatureJwksUri.toURL());
            signatureJwks.getKeys().forEach(t -> this.keyCache.put(t.getKeyID(), (RSAKey)t));
            return this.keyCache.getIfPresent(keyId);
        });
        if (key == null) {
            LOG.error("kid={} was not found in the key cache or {}", (Object)keyId, (Object)this.signatureJwksUri);
        }
        return key;
    }

    @PostConstruct
    public void init() throws MalformedURLException, IOException, ParseException {
        this.keyCache = CacheBuilder.newBuilder().maximumSize(20L).build();
        if (this.signatureJwksUri == null) {
            LOG.warn("authz.signature.jwks.uri not specified, no signature verification will be performed");
        }
        if (this.audience == null) {
            LOG.warn("`authz.audience` was not specified, will accept any audience");
        }
        if (this.issuer == null) {
            LOG.warn("`authz.issuer` was not specified, will accept any issuer");
        }
        if (this.claimsProcessor == null) {
            LOG.warn("JwtClaimsProcessor was not defined, will not peform any claims validation");
        }
        if (this.assertionRequiredPredicate == null) {
            LOG.debug("assertionRequiredPredicate was not defined, default annotation based predicate will be used");
            this.assertionRequiredPredicate = new DefaultAssertionRequiredFunction();
        }
    }

    @Autowired(required=false)
    public void setAssertionRequiredFunction(JwtAssertionRequiredPredicate assertionRequiredFunction) {
        this.assertionRequiredPredicate = assertionRequiredFunction;
    }

    @Autowired(required=false)
    public void setClaimsProcessor(JwtClaimsProcessor claimsProcessor) {
        this.claimsProcessor = claimsProcessor;
    }

    @Autowired
    public void setJwksProvider(JwksProvider jwksProvider) {
        this.jwksProvider = jwksProvider;
    }
}

