/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common.jaxrs;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlType(propOrder={"error", "errorDescription", "errorClass", "threadId", "stackTrace", "cause"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ErrorResponse {
    @XmlElement(name="cause", required=false)
    private final ErrorResponse cause;
    @XmlElement(required=true)
    private final String error;
    @XmlElement(name="error_class")
    private final String errorClass;
    @XmlElement(name="error_description")
    private final String errorDescription;
    @XmlElement(name="stack_trace")
    private final List<LocalStackTraceElement> stackTrace = new LinkedList<LocalStackTraceElement>();
    @XmlElement(name="thread_id")
    private final String threadId;

    protected ErrorResponse() {
        this.cause = null;
        this.error = null;
        this.errorClass = null;
        this.errorDescription = null;
        this.threadId = null;
    }

    public ErrorResponse(Throwable e) {
        this.error = "server_error";
        this.errorDescription = e.getLocalizedMessage();
        this.errorClass = e.getClass().getName();
        this.threadId = Thread.currentThread().getName();
        for (StackTraceElement ste : e.getStackTrace()) {
            if (this.isInternalClass(ste.getClassName())) continue;
            this.stackTrace.add(new LocalStackTraceElement(ste));
        }
        this.cause = e.getCause() != null ? new ErrorResponse(e.getCause()) : null;
    }

    public ErrorResponse getCause() {
        return this.cause;
    }

    public String getError() {
        return this.error;
    }

    public String getErrorClass() {
        return this.errorClass;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public List<LocalStackTraceElement> getStackTrace() {
        return this.stackTrace;
    }

    public String getThreadId() {
        return this.threadId;
    }

    private boolean isInternalClass(String className) {
        return className.startsWith("javax.") || className.startsWith("java.") || className.startsWith("sun.");
    }

    @XmlRootElement
    private static class LocalStackTraceElement {
        @XmlElement(name="class")
        private final String className;
        @XmlElement(name="file")
        private final String fileName;
        @XmlElement(name="line")
        private final int lineNumber;
        @XmlElement(name="method")
        private final String methodName;

        protected LocalStackTraceElement() {
            this.className = null;
            this.fileName = null;
            this.lineNumber = -1;
            this.methodName = null;
        }

        public LocalStackTraceElement(StackTraceElement ste) {
            this.className = ste.getClassName();
            this.methodName = ste.getMethodName();
            this.fileName = ste.getFileName();
            this.lineNumber = ste.getLineNumber();
        }

        public String getClassName() {
            return this.className;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getMethodName() {
            return this.methodName;
        }
    }
}

