/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common.internal.config;

import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ConfigurationProvider {
    @Value(value="${http.client.proxy.host:#{null}}")
    private String httpClientProxyHost;
    @Value(value="${http.client.proxy.password:#{null}}")
    private String httpClientProxyPassword;
    @Value(value="${http.client.proxy.port:3128}")
    private int httpClientProxyPort;
    @Value(value="${http.client.proxy.proxyType:HTTP}")
    private ProxyType httpClientProxyType;
    @Value(value="${http.client.proxy.username:#{null}}")
    private String httpClientProxyUsername;
    @Value(value="${http.port:8900}")
    private int httpPort;
    @Value(value="${vertx.warningExceptionTime:1}")
    private long vertxWarningExceptionTime;
    @Value(value="${vertx.workerPoolSize:50}")
    private int vertxWorkerPoolSize;

    @Bean
    public HttpClientOptions httpClientOptions() {
        HttpClientOptions options = new HttpClientOptions();
        if (this.httpClientProxyHost != null) {
            ProxyOptions proxyOptions = new ProxyOptions().setHost(this.httpClientProxyHost).setPort(this.httpClientProxyPort).setType(this.httpClientProxyType).setUsername(this.httpClientProxyUsername).setPassword(this.httpClientProxyPassword);
            options.setProxyOptions(proxyOptions);
        }
        return options;
    }

    @Bean
    public HttpServerOptions httpServerOptions() {
        HttpServerOptions options = new HttpServerOptions();
        options.setPort(this.httpPort);
        return options;
    }

    @Bean
    public VertxOptions vertxOptions() {
        VertxOptions options = new VertxOptions();
        options.setWarningExceptionTime(this.vertxWarningExceptionTime);
        options.setWorkerPoolSize(this.vertxWorkerPoolSize);
        return options;
    }
}

