/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common.beans;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSSigner;
import com.nimbusds.jose.crypto.RSASSASigner;
import com.nimbusds.jose.jwk.JWK;
import com.nimbusds.jose.jwk.JWKSet;
import com.nimbusds.jose.jwk.RSAKey;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.text.ParseException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.PostConstruct;
import net.trajano.ms.common.beans.TokenGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.Cache;
import org.springframework.cache.concurrent.ConcurrentMapCacheManager;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class JwksProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JwksProvider.class);
    public static final int MAX_NUMBER_OF_KEYS = 5;
    public static final int MIN_NUMBER_OF_KEYS = 2;
    private Cache jwksCache;
    private KeyPairGenerator keyPairGenerator;
    private Random random;
    private TokenGenerator tokenGenerator;

    @Scheduled(fixedDelay=60000L)
    public void buildJwks() {
        int nCreated = 0;
        for (int i = 0; i < 5; ++i) {
            String cacheKey = String.valueOf(i);
            String jwkJson = this.jwksCache.get((Object)cacheKey, String.class);
            JWK jwk = null;
            try {
                if (jwkJson != null) {
                    jwk = JWK.parse(jwkJson);
                }
            }
            catch (ParseException e) {
                LOG.error("unable to parse key={} json={} recreating entry", (Object)cacheKey, (Object)jwkJson);
            }
            if (jwk != null || nCreated >= 2) continue;
            jwk = this.buildNewRsaKey();
            this.jwksCache.putIfAbsent(cacheKey, jwk.toJSONString());
            ++nCreated;
            LOG.debug("Created new JWK kid={}", (Object)jwk.getKeyID());
        }
    }

    private JWK buildNewRsaKey() {
        KeyPair keyPair = this.keyPairGenerator.generateKeyPair();
        return new RSAKey.Builder((RSAPublicKey)keyPair.getPublic()).privateKey((RSAPrivateKey)keyPair.getPrivate()).keyID(this.tokenGenerator.newToken()).build();
    }

    public JWSSigner getASigner() throws InvalidKeySpecException, ParseException, JOSEException {
        return new RSASSASigner(this.getASigningKey().toRSAPrivateKey());
    }

    public RSAKey getASigningKey() {
        List<JWK> keys = this.getKeySet().getKeys();
        return (RSAKey)keys.get(this.random.nextInt(keys.size()));
    }

    public RSAKey getDecryptionKey(String keyID) {
        return (RSAKey)this.getKeySet().getKeyByKeyId(keyID);
    }

    public JWKSet getKeySet() {
        LinkedList<JWK> keys = new LinkedList<JWK>();
        for (int i = 0; i < 5; ++i) {
            String cacheKey = String.valueOf(i);
            String jwkJson = this.jwksCache.get((Object)cacheKey, String.class);
            try {
                if (jwkJson == null) continue;
                keys.add(JWK.parse(jwkJson));
                continue;
            }
            catch (ParseException e) {
                LOG.error("unable to parse key={} json={} removing entry", (Object)cacheKey, (Object)jwkJson);
                this.jwksCache.evict(cacheKey);
            }
        }
        return new JWKSet(keys);
    }

    @PostConstruct
    public void init() {
        if (this.jwksCache == null) {
            LOG.warn("A org.springframework.cache.Cache named {} was not provided an in-memory cache will be used", (Object)"jwks_cache");
            ConcurrentMapCacheManager cm = new ConcurrentMapCacheManager("jwks_cache");
            this.jwksCache = cm.getCache("jwks_cache");
        }
        LOG.debug("cache=" + this.jwksCache);
        this.buildJwks();
    }

    @Autowired(required=false)
    @Qualifier(value="jwks_cache")
    public void setJwksCache(Cache jwksCache) {
        this.jwksCache = jwksCache;
    }

    @Autowired
    public void setKeyPairGenerator(KeyPairGenerator keyPairGenerator) {
        this.keyPairGenerator = keyPairGenerator;
    }

    @Autowired
    public void setRandom(Random random) {
        this.random = random;
    }

    @Autowired
    public void setTokenGenerator(TokenGenerator tokenGenerator) {
        this.tokenGenerator = tokenGenerator;
    }
}

