/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import java.util.Deque;
import java.util.LinkedList;
import net.trajano.ms.engine.ManifestHandler;
import net.trajano.ms.engine.SpringJaxRsHandler;
import net.trajano.ms.engine.SwaggerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MicroserviceVerticle
extends AbstractVerticle {
    private static final Logger LOG = LoggerFactory.getLogger(SpringJaxRsHandler.class);
    private final Deque<AutoCloseable> handlerStack = new LinkedList<AutoCloseable>();

    @Override
    public void start() throws Exception {
        Router router = Router.router(this.vertx);
        Class<?> applicationClass = Class.forName(this.config().getString("application_class"));
        LOG.debug("Application={}", (Object)applicationClass.getName());
        this.handlerStack.push(SwaggerHandler.registerToRouter(router, applicationClass));
        this.handlerStack.push(ManifestHandler.registerToRouter(router));
        this.handlerStack.push(SpringJaxRsHandler.registerToRouter(router, applicationClass));
        HttpServerOptions httpServerOptions = new HttpServerOptions(this.config().getJsonObject("http"));
        HttpServer http = this.vertx.createHttpServer(httpServerOptions);
        http.requestHandler(router::accept).listen(res -> {
            if (res.failed()) {
                LOG.error(res.cause().getMessage(), res.cause());
                this.vertx.close();
            } else {
                LOG.debug("Listening on port {}", (Object)http.actualPort());
            }
        });
    }

    @Override
    public void stop() throws Exception {
        while (this.handlerStack.peek() != null) {
            this.handlerStack.pop().close();
        }
    }
}

