/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import java.util.Deque;
import java.util.LinkedList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ws.rs.core.Application;
import net.trajano.ms.common.beans.CommonMs;
import net.trajano.ms.common.beans.JwksRouteHandler;
import net.trajano.ms.common.internal.config.ConfigurationProvider;
import net.trajano.ms.common.jaxrs.CommonMsJaxRs;
import net.trajano.ms.engine.ManifestHandler;
import net.trajano.ms.engine.SpringJaxRsHandler;
import net.trajano.ms.engine.SwaggerHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.Banner;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.stereotype.Component;

@Component
public class Microservice {
    private static Class<? extends Application> applicationClass;
    private static final Logger LOG;
    @Autowired
    private ConfigurableApplicationContext baseApplicationContext;
    private final Deque<AutoCloseable> handlerStack = new LinkedList<AutoCloseable>();
    @Autowired
    private HttpServerOptions httpServerOptions;
    private Vertx vertx;
    @Autowired
    private VertxOptions vertxOptions;

    public static void run(Class<? extends Application> applicationClass, String ... args) {
        if (Microservice.applicationClass != null) {
            throw new IllegalStateException("Another Application class has already been registered in this JVM.");
        }
        Microservice.applicationClass = applicationClass;
        Object[] sources = new Object[]{ConfigurationProvider.class, Microservice.class};
        SpringApplication springApplication = new SpringApplication(sources);
        springApplication.setBannerMode(Banner.Mode.OFF);
        springApplication.run(args);
    }

    @PostConstruct
    public void start() {
        LOG.debug("Application={}", (Object)applicationClass.getName());
        this.vertx = Vertx.vertx(this.vertxOptions);
        Router router = Router.router(this.vertx);
        this.handlerStack.push(SwaggerHandler.registerToRouter(router, applicationClass));
        this.handlerStack.push(ManifestHandler.registerToRouter(router));
        AnnotationConfigApplicationContext applicationContext = new AnnotationConfigApplicationContext();
        applicationContext.setParent(this.baseApplicationContext);
        applicationContext.register(CommonMs.class);
        applicationContext.register(CommonMsJaxRs.class);
        this.handlerStack.push(SpringJaxRsHandler.registerToRouter(router, applicationContext, applicationClass));
        JwksRouteHandler jwksRouteHandler = applicationContext.getBean(JwksRouteHandler.class);
        router.route("/.well-known/jwks").handler(jwksRouteHandler);
        HttpServer http = this.vertx.createHttpServer(this.httpServerOptions);
        http.requestHandler(router::accept).listen(res -> {
            if (res.failed()) {
                LOG.error(res.cause().getMessage(), res.cause());
                this.vertx.close();
            } else {
                LOG.info("Listening on port {}", (Object)http.actualPort());
            }
        });
    }

    @PreDestroy
    public void stop() throws Exception {
        while (this.handlerStack.peek() != null) {
            this.handlerStack.pop().close();
        }
        this.vertx.close();
    }

    static {
        LOG = LoggerFactory.getLogger(Microservice.class);
    }
}

