/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.common;

import com.nimbusds.jwt.JWTClaimsSet;
import java.net.URI;
import java.security.Principal;
import javax.ws.rs.core.UriBuilder;

public class IdTokenPrincipal
implements Principal {
    private final String authority;
    private final JWTClaimsSet claimsSet;

    public IdTokenPrincipal(JWTClaimsSet claimsSet) {
        this.claimsSet = claimsSet;
        URI build = UriBuilder.fromUri(claimsSet.getIssuer()).userInfo(claimsSet.getSubject()).build(new Object[0]);
        this.authority = build.getAuthority();
    }

    public String getAuthority() {
        return this.authority;
    }

    public JWTClaimsSet getClaimsSet() {
        return this.claimsSet;
    }

    @Override
    public String getName() {
        return this.claimsSet.getSubject();
    }
}

