/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;

public class RedirectAuthHandlerImpl
extends AuthHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(RedirectAuthHandlerImpl.class);
    private final String loginRedirectURL;
    private final String returnURLParam;

    public RedirectAuthHandlerImpl(AuthProvider authProvider, String loginRedirectURL, String returnURLParam) {
        super(authProvider);
        this.loginRedirectURL = loginRedirectURL;
        this.returnURLParam = returnURLParam;
    }

    @Override
    public void handle(RoutingContext context) {
        Session session = context.session();
        if (session != null) {
            User user = context.user();
            if (user != null) {
                this.authorise(user, context);
            } else {
                session.put(this.returnURLParam, context.request().uri());
                context.response().putHeader("location", this.loginRedirectURL).setStatusCode(302).end();
            }
        } else {
            context.fail(new NullPointerException("No session - did you forget to include a SessionHandler?"));
        }
    }
}

