/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.impl;

import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.AuthProvider;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.htdigest.HtdigestAuth;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.Session;
import io.vertx.ext.web.handler.DigestAuthHandler;
import io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DigestAuthHandlerImpl
extends AuthHandlerImpl
implements DigestAuthHandler {
    private static final Pattern PARSER = Pattern.compile("(\\w+)=[\"]?([^\"]*)[\"]?$");
    private static final MessageDigest MD5;
    private final SecureRandom random = new SecureRandom();
    private final Map<String, Nonce> nonces = new HashMap<String, Nonce>();
    private final long nonceExpireTimeout;
    private long lastExpireRun;
    private static final char[] hexArray;

    public DigestAuthHandlerImpl(HtdigestAuth authProvider, long nonceExpireTimeout) {
        super((AuthProvider)authProvider);
        this.nonceExpireTimeout = nonceExpireTimeout;
    }

    @Override
    public void handle(RoutingContext context) {
        User user;
        long now = System.currentTimeMillis();
        if (now - this.lastExpireRun > this.nonceExpireTimeout / 2L) {
            Iterator<Map.Entry<String, Nonce>> it = this.nonces.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Nonce> entry = it.next();
                if (entry.getValue().createdAt + this.nonceExpireTimeout >= now) continue;
                it.remove();
            }
            this.lastExpireRun = now;
        }
        if ((user = context.user()) != null) {
            this.authorise(user, context);
        } else {
            HttpServerRequest request = context.request();
            String authorization = request.headers().get(HttpHeaders.AUTHORIZATION);
            if (authorization == null) {
                this.handle401(context);
            } else {
                try {
                    String opaque;
                    Session session;
                    int idx = authorization.indexOf(32);
                    if (idx <= 0) {
                        context.fail(400);
                        return;
                    }
                    String sscheme = authorization.substring(0, idx);
                    if (!"Digest".equalsIgnoreCase(sscheme)) {
                        context.fail(400);
                        return;
                    }
                    JsonObject authInfo = new JsonObject();
                    String[] tokens = authorization.substring(idx).split(",(?=(?:[^\"]|\"[^\"]*\")*$)");
                    int len = tokens.length;
                    for (int i = 0; i < len; ++i) {
                        Matcher m = PARSER.matcher(tokens[i]);
                        if (!m.find()) continue;
                        authInfo.put(m.group(1), m.group(2));
                    }
                    String nonce = authInfo.getString("nonce");
                    if (!this.nonces.containsKey(nonce)) {
                        this.handle401(context);
                        return;
                    }
                    if (authInfo.containsKey("qop")) {
                        Integer nc = Integer.parseInt(authInfo.getString("nc"));
                        Nonce n = this.nonces.get(nonce);
                        if (nc <= n.count) {
                            this.handle401(context);
                            return;
                        }
                        n.count = nc;
                    }
                    if ((session = context.session()) != null && (opaque = (String)session.data().get("opaque")) != null && !opaque.equals(authInfo.getString("opaque"))) {
                        this.handle401(context);
                        return;
                    }
                    authInfo.put("method", context.request().method().name());
                    this.authProvider.authenticate(authInfo, res -> {
                        if (res.succeeded()) {
                            User authenticated = (User)res.result();
                            context.setUser(authenticated);
                            if (session != null) {
                                session.regenerateId();
                            }
                            this.authorise(authenticated, context);
                        } else {
                            this.handle401(context);
                        }
                    });
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    this.handle401(context);
                }
                catch (IllegalArgumentException | NullPointerException e) {
                    context.fail(e);
                }
            }
        }
    }

    private void handle401(RoutingContext context) {
        byte[] bytes = new byte[32];
        this.random.nextBytes(bytes);
        String nonce = DigestAuthHandlerImpl.md5(bytes);
        this.nonces.put(nonce, new Nonce());
        String opaque = null;
        Session session = context.session();
        if (session != null) {
            opaque = (String)session.data().get("opaque");
        }
        if (opaque == null) {
            this.random.nextBytes(bytes);
            opaque = DigestAuthHandlerImpl.md5(bytes);
        }
        context.response().putHeader("WWW-Authenticate", "Digest realm=\"" + ((HtdigestAuth)this.authProvider).realm() + "\", qop=\"auth\", nonce=\"" + nonce + "\", opaque=\"" + opaque + "\"");
        context.fail(401);
    }

    private static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    private static synchronized String md5(byte[] payload) {
        MD5.reset();
        return DigestAuthHandlerImpl.bytesToHex(MD5.digest(payload));
    }

    static {
        try {
            MD5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        hexArray = "0123456789abcdef".toCharArray();
    }

    private static class Nonce {
        private final long createdAt = System.currentTimeMillis();
        private int count = 0;

        Nonce() {
        }
    }
}

