/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.net.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.net.impl.VertxSniHandler;
import io.vertx.core.spi.metrics.NetworkMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.cert.X509Certificate;

public abstract class ConnectionBase {
    private static final Logger log = LoggerFactory.getLogger(ConnectionBase.class);
    protected final VertxInternal vertx;
    protected final Channel channel;
    protected final ContextImpl context;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private boolean read;
    private boolean needsFlush;
    private Thread ctxThread;
    private boolean needsAsyncFlush;
    private Object metric;

    protected ConnectionBase(VertxInternal vertx, Channel channel, ContextImpl context) {
        this.vertx = vertx;
        this.channel = channel;
        this.context = context;
    }

    protected final synchronized void startRead() {
        this.checkContext();
        this.read = true;
        if (this.ctxThread == null) {
            this.ctxThread = Thread.currentThread();
        }
    }

    protected final synchronized void endReadAndFlush() {
        this.read = false;
        if (this.needsFlush) {
            this.needsFlush = false;
            if (this.needsAsyncFlush) {
                this.context.runOnContext(v -> this.channel.flush());
            } else {
                this.channel.flush();
            }
        }
    }

    public synchronized ChannelFuture queueForWrite(Object obj) {
        this.needsFlush = true;
        this.needsAsyncFlush = Thread.currentThread() != this.ctxThread;
        return this.channel.write(obj);
    }

    public synchronized ChannelFuture writeToChannel(Object obj) {
        if (this.read) {
            return this.queueForWrite(obj);
        }
        if (this.channel.isOpen()) {
            return this.channel.writeAndFlush(obj);
        }
        return null;
    }

    public boolean isNotWritable() {
        return !this.channel.isWritable();
    }

    public void close() {
        this.endReadAndFlush();
        this.channel.close();
    }

    public synchronized ConnectionBase closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
        return this;
    }

    public synchronized ConnectionBase exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    protected synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    public void doPause() {
        this.channel.config().setAutoRead(false);
    }

    public void doResume() {
        this.channel.config().setAutoRead(true);
    }

    public void doSetWriteQueueMaxSize(int size) {
        ChannelConfig config = this.channel.config();
        int high = config.getWriteBufferHighWaterMark();
        int newLow = size / 2;
        int newHigh = size;
        if (newLow >= high) {
            config.setWriteBufferHighWaterMark(newHigh);
            config.setWriteBufferLowWaterMark(newLow);
        } else {
            config.setWriteBufferLowWaterMark(newLow);
            config.setWriteBufferHighWaterMark(newHigh);
        }
    }

    protected void checkContext() {
        if (this.context != this.vertx.getContext()) {
            throw new IllegalStateException("Wrong context!");
        }
    }

    public ContextImpl getContext() {
        return this.context;
    }

    public synchronized void metric(Object metric) {
        this.metric = metric;
    }

    public synchronized Object metric() {
        return this.metric;
    }

    public abstract NetworkMetrics metrics();

    protected synchronized void handleException(Throwable t) {
        this.metrics().exceptionOccurred(this.metric(), this.remoteAddress(), t);
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle(t);
        } else {
            log.error(t);
        }
    }

    protected synchronized void handleClosed() {
        NetworkMetrics metrics = this.metrics();
        if (metrics instanceof TCPMetrics) {
            ((TCPMetrics)metrics).disconnected(this.metric(), this.remoteAddress());
        }
        if (this.closeHandler != null) {
            this.vertx.runOnContext(this.closeHandler);
        }
    }

    protected abstract void handleInterestedOpsChanged();

    protected void addFuture(Handler<AsyncResult<Void>> completionHandler, ChannelFuture future) {
        if (future != null) {
            future.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)channelFuture -> this.context.executeFromIO(() -> {
                if (completionHandler != null) {
                    if (channelFuture.isSuccess()) {
                        completionHandler.handle(Future.succeededFuture());
                    } else {
                        completionHandler.handle(Future.failedFuture(channelFuture.cause()));
                    }
                } else if (!channelFuture.isSuccess()) {
                    this.handleException(channelFuture.cause());
                }
            })));
        }
    }

    protected boolean supportsFileRegion() {
        return !this.isSSL();
    }

    public void reportBytesRead(long numberOfBytes) {
        NetworkMetrics metrics = this.metrics();
        if (metrics.isEnabled()) {
            metrics.bytesRead(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    public void reportBytesWritten(long numberOfBytes) {
        NetworkMetrics metrics = this.metrics();
        if (metrics.isEnabled()) {
            metrics.bytesWritten(this.metric(), this.remoteAddress(), numberOfBytes);
        }
    }

    private boolean isSSL() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }

    protected ChannelFuture sendFile(RandomAccessFile raf, long offset, long length) throws IOException {
        ChannelFuture writeFuture;
        if (!this.supportsFileRegion()) {
            writeFuture = this.writeToChannel(new ChunkedFile(raf, offset, length, 8192));
        } else {
            DefaultFileRegion region = new DefaultFileRegion(raf.getChannel(), offset, length);
            writeFuture = this.writeToChannel(region);
        }
        if (writeFuture != null) {
            writeFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> raf.close()));
        } else {
            raf.close();
        }
        return writeFuture;
    }

    public boolean isSsl() {
        return this.channel.pipeline().get(SslHandler.class) != null;
    }

    public X509Certificate[] peerCertificateChain() throws SSLPeerUnverifiedException {
        if (this.isSSL()) {
            ChannelHandlerContext sslHandlerContext = this.channel.pipeline().context("ssl");
            assert (sslHandlerContext != null);
            SslHandler sslHandler = (SslHandler)sslHandlerContext.handler();
            return sslHandler.engine().getSession().getPeerCertificateChain();
        }
        return null;
    }

    public String indicatedServerName() {
        if (this.channel.hasAttr(VertxSniHandler.SERVER_NAME_ATTR)) {
            return this.channel.attr(VertxSniHandler.SERVER_NAME_ATTR).get();
        }
        return null;
    }

    public String remoteName() {
        InetSocketAddress addr = (InetSocketAddress)this.channel.remoteAddress();
        if (addr == null) {
            return null;
        }
        return addr.getHostString();
    }

    public SocketAddress remoteAddress() {
        InetSocketAddress addr = (InetSocketAddress)this.channel.remoteAddress();
        if (addr == null) {
            return null;
        }
        return new SocketAddressImpl(addr);
    }

    public SocketAddress localAddress() {
        InetSocketAddress addr = (InetSocketAddress)this.channel.localAddress();
        if (addr == null) {
            return null;
        }
        return new SocketAddressImpl(addr);
    }
}

