/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Flags;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.http.impl.Http2ConnectionBase;
import java.util.Map;
import java.util.function.Function;

class VertxHttp2ConnectionHandler<C extends Http2ConnectionBase>
extends Http2ConnectionHandler
implements Http2Connection.Listener {
    private final Map<Channel, ? super C> connectionMap;
    C connection;
    private ChannelHandlerContext ctx;

    public VertxHttp2ConnectionHandler(Map<Channel, ? super C> connectionMap, Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings, Function<VertxHttp2ConnectionHandler<C>, C> connectionFactory) {
        super(decoder, encoder, initialSettings);
        this.connectionMap = connectionMap;
        this.connection = (Http2ConnectionBase)connectionFactory.apply(this);
        this.encoder().flowController().listener(s -> ((Http2ConnectionBase)this.connection).onStreamwritabilityChanged(s));
        this.connection().addListener(this);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        ((Http2ConnectionBase)this.connection).setHandlerContext(ctx);
        this.connectionMap.put(ctx.channel(), this.connection);
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        super.exceptionCaught(ctx, cause);
        ctx.close();
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        super.channelInactive(ctx);
        this.connectionMap.remove(ctx.channel());
        ((Http2ConnectionBase)this.connection).getContext().executeFromIO(() -> this.connection.handleClosed());
    }

    @Override
    protected void onConnectionError(ChannelHandlerContext ctx, Throwable cause, Http2Exception http2Ex) {
        ((Http2ConnectionBase)this.connection).getContext().executeFromIO(() -> ((Http2ConnectionBase)this.connection).onConnectionError(cause));
        super.onConnectionError(ctx, cause, http2Ex);
    }

    @Override
    protected void onStreamError(ChannelHandlerContext ctx, Throwable cause, Http2Exception.StreamException http2Ex) {
        ((Http2ConnectionBase)this.connection).getContext().executeFromIO(() -> ((Http2ConnectionBase)this.connection).onStreamError(http2Ex.streamId(), http2Ex));
        super.onStreamError(ctx, cause, http2Ex);
    }

    @Override
    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            super.userEventTriggered(ctx, evt);
        }
        finally {
            if (evt instanceof IdleStateEvent && ((IdleStateEvent)evt).state() == IdleState.ALL_IDLE) {
                ctx.close();
            }
        }
    }

    @Override
    public void onStreamClosed(Http2Stream stream) {
        ((Http2ConnectionBase)this.connection).onStreamClosed(stream);
    }

    @Override
    public void onStreamAdded(Http2Stream stream) {
    }

    @Override
    public void onStreamActive(Http2Stream stream) {
    }

    @Override
    public void onStreamHalfClosed(Http2Stream stream) {
    }

    @Override
    public void onStreamRemoved(Http2Stream stream) {
    }

    @Override
    public void onPriorityTreeParentChanged(Http2Stream stream, Http2Stream oldParent) {
    }

    @Override
    public void onPriorityTreeParentChanging(Http2Stream stream, Http2Stream newParent) {
    }

    @Override
    public void onWeightChanged(Http2Stream stream, short oldWeight) {
    }

    @Override
    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        ((Http2ConnectionBase)this.connection).onGoAwaySent(lastStreamId, errorCode, debugData);
    }

    @Override
    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        ((Http2ConnectionBase)this.connection).onGoAwayReceived(lastStreamId, errorCode, debugData);
    }

    void writeHeaders(Http2Stream stream, Http2Headers headers, boolean end) {
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writeHeaders(stream, headers, end);
        } else {
            executor.execute(() -> this._writeHeaders(stream, headers, end));
        }
    }

    private void _writeHeaders(Http2Stream stream, Http2Headers headers, boolean end) {
        this.encoder().writeHeaders(this.ctx, stream.id(), headers, 0, end, this.ctx.newPromise());
    }

    void writeData(Http2Stream stream, ByteBuf chunk, boolean end) {
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writeData(stream, chunk, end);
        } else {
            executor.execute(() -> this._writeData(stream, chunk, end));
        }
    }

    private void _writeData(Http2Stream stream, ByteBuf chunk, boolean end) {
        this.encoder().writeData(this.ctx, stream.id(), chunk, 0, end, this.ctx.newPromise());
        Http2RemoteFlowController controller = this.encoder().flowController();
        if (!controller.isWritable(stream) || end) {
            try {
                this.encoder().flowController().writePendingBytes();
            }
            catch (Http2Exception e) {
                this.onError(this.ctx, e);
            }
        }
        this.ctx.channel().flush();
    }

    ChannelFuture writePing(ByteBuf data) {
        ChannelPromise promise = this.ctx.newPromise();
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writePing(data, promise);
        } else {
            executor.execute(() -> this._writePing(data, promise));
        }
        return promise;
    }

    private void _writePing(ByteBuf data, ChannelPromise promise) {
        this.encoder().writePing(this.ctx, false, data, promise);
        this.ctx.channel().flush();
    }

    void consume(Http2Stream stream, int numBytes) {
        try {
            boolean windowUpdateSent = this.decoder().flowController().consumeBytes(stream, numBytes);
            if (windowUpdateSent) {
                this.ctx.channel().flush();
            }
        }
        catch (Http2Exception e) {
            this.onError(this.ctx, e);
        }
    }

    void writeFrame(Http2Stream stream, byte type, short flags, ByteBuf payload) {
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writeFrame(stream, type, flags, payload);
        } else {
            executor.execute(() -> this._writeFrame(stream, type, flags, payload));
        }
    }

    private void _writeFrame(Http2Stream stream, byte type, short flags, ByteBuf payload) {
        this.encoder().writeFrame(this.ctx, type, stream.id(), new Http2Flags(flags), payload, this.ctx.newPromise());
        this.ctx.flush();
    }

    void writeReset(int streamId, long code) {
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writeReset(streamId, code);
        } else {
            executor.execute(() -> this._writeReset(streamId, code));
        }
    }

    private void _writeReset(int streamId, long code) {
        this.encoder().writeRstStream(this.ctx, streamId, code, this.ctx.newPromise());
        this.ctx.flush();
    }

    void writeGoAway(long errorCode, int lastStreamId, ByteBuf debugData) {
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writeGoAway(errorCode, lastStreamId, debugData);
        } else {
            executor.execute(() -> this._writeGoAway(errorCode, lastStreamId, debugData));
        }
    }

    private void _writeGoAway(long errorCode, int lastStreamId, ByteBuf debugData) {
        this.encoder().writeGoAway(this.ctx, lastStreamId, errorCode, debugData, this.ctx.newPromise());
        this.ctx.flush();
    }

    ChannelFuture writeSettings(Http2Settings settingsUpdate) {
        ChannelPromise promise = this.ctx.newPromise();
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writeSettings(settingsUpdate, promise);
        } else {
            executor.execute(() -> this._writeSettings(settingsUpdate, promise));
        }
        return promise;
    }

    private void _writeSettings(Http2Settings settingsUpdate, ChannelPromise promise) {
        this.encoder().writeSettings(this.ctx, settingsUpdate, promise);
        this.ctx.flush();
    }

    void writePushPromise(int streamId, Http2Headers headers, Handler<AsyncResult<Integer>> completionHandler) {
        int promisedStreamId = this.connection().local().incrementAndGetNextStreamId();
        ChannelPromise promise = this.ctx.newPromise();
        promise.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> {
            if (fut.isSuccess()) {
                completionHandler.handle(Future.succeededFuture(promisedStreamId));
            } else {
                completionHandler.handle(Future.failedFuture(fut.cause()));
            }
        }));
        EventExecutor executor = this.ctx.executor();
        if (executor.inEventLoop()) {
            this._writePushPromise(streamId, promisedStreamId, headers, promise);
        } else {
            executor.execute(() -> this._writePushPromise(streamId, promisedStreamId, headers, promise));
        }
    }

    private void _writePushPromise(int streamId, int promisedStreamId, Http2Headers headers, ChannelPromise promise) {
        this.encoder().writePushPromise(this.ctx, streamId, promisedStreamId, headers, 0, promise);
    }
}

