/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.AssembledFullHttpResponse;
import io.vertx.core.http.impl.AssembledHttpResponse;
import io.vertx.core.http.impl.AssembledLastHttpContent;
import io.vertx.core.http.impl.HeadersAdaptor;
import io.vertx.core.http.impl.MimeMapping;
import io.vertx.core.http.impl.ServerConnection;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class HttpServerResponseImpl
implements HttpServerResponse {
    private static final Logger log = LoggerFactory.getLogger(HttpServerResponseImpl.class);
    private final VertxInternal vertx;
    private final ServerConnection conn;
    private final HttpResponse response;
    private final HttpVersion version;
    private final boolean keepAlive;
    private final boolean head;
    private boolean headWritten;
    private boolean written;
    private Handler<Void> drainHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private Handler<Void> endHandler;
    private Handler<Void> headersEndHandler;
    private Handler<Void> bodyEndHandler;
    private boolean chunked;
    private boolean closed;
    private ChannelFuture channelFuture;
    private MultiMap headers;
    private LastHttpContent trailing;
    private MultiMap trailers;
    private String statusMessage;
    private long bytesWritten;

    HttpServerResponseImpl(VertxInternal vertx, ServerConnection conn, HttpRequest request) {
        this.vertx = vertx;
        this.conn = conn;
        this.version = request.getProtocolVersion();
        this.response = new DefaultHttpResponse(this.version, HttpResponseStatus.OK, false);
        this.keepAlive = this.version == HttpVersion.HTTP_1_1 && !request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.CLOSE, true) || this.version == HttpVersion.HTTP_1_0 && request.headers().contains(HttpHeaders.CONNECTION, HttpHeaders.KEEP_ALIVE, true);
        this.head = request.method() == io.netty.handler.codec.http.HttpMethod.HEAD;
    }

    @Override
    public MultiMap headers() {
        if (this.headers == null) {
            this.headers = new HeadersAdaptor(this.response.headers());
        }
        return this.headers;
    }

    @Override
    public MultiMap trailers() {
        if (this.trailers == null) {
            if (this.trailing == null) {
                this.trailing = new DefaultLastHttpContent(Unpooled.EMPTY_BUFFER, false);
            }
            this.trailers = new HeadersAdaptor(this.trailing.trailingHeaders());
        }
        return this.trailers;
    }

    @Override
    public int getStatusCode() {
        return this.response.getStatus().code();
    }

    @Override
    public HttpServerResponse setStatusCode(int statusCode) {
        HttpResponseStatus status = this.statusMessage != null ? new HttpResponseStatus(statusCode, this.statusMessage) : HttpResponseStatus.valueOf(statusCode);
        this.response.setStatus(status);
        return this;
    }

    @Override
    public String getStatusMessage() {
        return this.response.getStatus().reasonPhrase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setStatusMessage(String statusMessage) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.statusMessage = statusMessage;
            this.response.setStatus(new HttpResponseStatus(this.response.getStatus().code(), statusMessage));
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl setChunked(boolean chunked) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            if (this.version != HttpVersion.HTTP_1_0) {
                this.chunked = chunked;
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isChunked() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.chunked;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putHeader(String key, String value) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.headers().set(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putHeader(String key, Iterable<String> values) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.headers().set(key, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putTrailer(String key, String value) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.trailers().set(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponseImpl putTrailer(String key, Iterable<String> values) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.trailers().set(key, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, CharSequence value) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.headers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putHeader(CharSequence name, Iterable<CharSequence> values) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.headers().set(name, values);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, CharSequence value) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse putTrailer(CharSequence name, Iterable<CharSequence> value) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.trailers().set(name, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse setWriteQueueMaxSize(int size) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.conn.doSetWriteQueueMaxSize(size);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean writeQueueFull() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            return this.conn.isNotWritable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse drainHandler(Handler<Void> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.drainHandler = handler;
            this.conn.getContext().runOnContext(v -> this.conn.handleInterestedOpsChanged());
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse exceptionHandler(Handler<Throwable> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.exceptionHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse closeHandler(Handler<Void> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.closeHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse endHandler(@Nullable Handler<Void> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            this.endHandler = handler;
            return this;
        }
    }

    @Override
    public HttpServerResponseImpl write(Buffer chunk) {
        ByteBuf buf = chunk.getByteBuf();
        return this.write(buf);
    }

    @Override
    public HttpServerResponseImpl write(String chunk, String enc) {
        return this.write(Buffer.buffer(chunk, enc).getByteBuf());
    }

    @Override
    public HttpServerResponseImpl write(String chunk) {
        return this.write(Buffer.buffer(chunk).getByteBuf());
    }

    @Override
    public HttpServerResponse writeContinue() {
        this.conn.write100Continue();
        return this;
    }

    @Override
    public void end(String chunk) {
        this.end(Buffer.buffer(chunk));
    }

    @Override
    public void end(String chunk, String enc) {
        this.end(Buffer.buffer(chunk, enc));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Buffer chunk) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (!this.chunked && !this.contentLengthSet()) {
                this.headers().set(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(chunk.length()));
            }
            ByteBuf buf = chunk.getByteBuf();
            this.end0(buf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (!this.closed) {
                if (this.headWritten) {
                    this.closeConnAfterWrite();
                } else {
                    this.conn.close();
                }
                this.closed = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.end0(Unpooled.EMPTY_BUFFER);
        }
    }

    @Override
    public HttpServerResponseImpl sendFile(String filename, long offset, long length) {
        this.doSendFile(filename, offset, length, null);
        return this;
    }

    @Override
    public HttpServerResponse sendFile(String filename, long start, long end, Handler<AsyncResult<Void>> resultHandler) {
        this.doSendFile(filename, start, end, resultHandler);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean ended() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.written;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean closed() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean headWritten() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.headWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long bytesWritten() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            return this.bytesWritten;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse headersEndHandler(Handler<Void> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.headersEndHandler = handler;
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpServerResponse bodyEndHandler(Handler<Void> handler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.bodyEndHandler = handler;
            return this;
        }
    }

    private void end0(ByteBuf data) {
        this.checkWritten();
        this.bytesWritten += (long)data.readableBytes();
        if (!this.headWritten) {
            this.prepareHeaders();
            AssembledFullHttpResponse resp = this.trailing != null ? new AssembledFullHttpResponse(this.response, data, this.trailing.trailingHeaders(), this.trailing.getDecoderResult()) : (this.head ? new AssembledFullHttpResponse(this.response) : new AssembledFullHttpResponse(this.response, data));
            this.channelFuture = this.conn.writeToChannel(resp);
        } else if (!data.isReadable()) {
            this.channelFuture = this.trailing == null ? this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT) : this.conn.writeToChannel(this.trailing);
        } else {
            LastHttpContent content = this.trailing != null ? new AssembledLastHttpContent(data, this.trailing.trailingHeaders(), this.trailing.getDecoderResult()) : new DefaultLastHttpContent(data, false);
            this.channelFuture = this.conn.writeToChannel(content);
        }
        if (!this.keepAlive) {
            this.closeConnAfterWrite();
            this.closed = true;
        }
        this.written = true;
        this.conn.responseComplete();
        if (this.bodyEndHandler != null) {
            this.bodyEndHandler.handle(null);
        }
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendFile(String filename, long offset, long length, Handler<AsyncResult<Void>> resultHandler) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            String contentType;
            long contentLength;
            if (this.headWritten) {
                throw new IllegalStateException("Head already written");
            }
            this.checkWritten();
            File file = this.vertx.resolveFile(filename);
            if (!file.exists()) {
                if (resultHandler != null) {
                    ContextImpl ctx = this.vertx.getOrCreateContext();
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture(new FileNotFoundException())));
                } else {
                    log.error("File not found: " + filename);
                }
                return;
            }
            this.bytesWritten = contentLength = Math.min(length, file.length() - offset);
            if (!this.contentLengthSet()) {
                this.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(contentLength));
            }
            if (!this.contentTypeSet() && (contentType = MimeMapping.getMimeTypeForFilename(filename)) != null) {
                this.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)contentType);
            }
            this.prepareHeaders();
            RandomAccessFile raf = null;
            try {
                raf = new RandomAccessFile(file, "r");
                this.conn.queueForWrite(this.response);
                this.conn.sendFile(raf, Math.min(offset, file.length()), contentLength);
            }
            catch (IOException e) {
                try {
                    if (raf != null) {
                        raf.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (resultHandler != null) {
                    ContextImpl ctx = this.vertx.getOrCreateContext();
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture(e)));
                } else {
                    log.error((Object)"Failed to send file", e);
                }
                return;
            }
            this.channelFuture = this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
            this.written = true;
            if (resultHandler != null) {
                ContextImpl ctx = this.vertx.getOrCreateContext();
                if (this.channelFuture == null) {
                    ctx.runOnContext(v -> resultHandler.handle(Future.failedFuture("Channel Unavailable")));
                } else {
                    this.channelFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)future -> {
                        Future res = future.isSuccess() ? Future.succeededFuture() : Future.failedFuture(future.cause());
                        ctx.runOnContext(v -> resultHandler.handle(res));
                    }));
                }
            }
            if (!this.keepAlive) {
                this.closeConnAfterWrite();
            }
            this.conn.responseComplete();
            if (this.bodyEndHandler != null) {
                this.bodyEndHandler.handle(null);
            }
        }
    }

    private boolean contentLengthSet() {
        if (this.headers == null) {
            return false;
        }
        return this.response.headers().contains(HttpHeaders.CONTENT_LENGTH);
    }

    private boolean contentTypeSet() {
        if (this.headers == null) {
            return false;
        }
        return this.response.headers().contains(HttpHeaders.CONTENT_TYPE);
    }

    private void closeConnAfterWrite() {
        if (this.channelFuture != null) {
            this.channelFuture.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<io.netty.util.concurrent.Future>)fut -> this.conn.close()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDrained() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (this.drainHandler != null) {
                this.drainHandler.handle(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleException(Throwable t) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleClosed() {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            if (this.endHandler != null) {
                this.conn.getContext().runOnContext(this.endHandler);
            }
            if (this.closeHandler != null) {
                this.conn.getContext().runOnContext(this.closeHandler);
            }
        }
    }

    private void checkWritten() {
        if (this.written) {
            throw new IllegalStateException("Response has already been written");
        }
    }

    private void prepareHeaders() {
        if (this.version == HttpVersion.HTTP_1_0 && this.keepAlive) {
            this.response.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
        } else if (this.version == HttpVersion.HTTP_1_1 && !this.keepAlive) {
            this.response.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
        }
        if (!this.head) {
            if (this.chunked) {
                this.response.headers().set(HttpHeaders.TRANSFER_ENCODING, (Object)HttpHeaders.CHUNKED);
            } else if (this.keepAlive && !this.contentLengthSet()) {
                this.response.headers().set(HttpHeaders.CONTENT_LENGTH, (Object)"0");
            }
        }
        if (this.headersEndHandler != null) {
            this.headersEndHandler.handle(null);
        }
        this.headWritten = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpServerResponseImpl write(ByteBuf chunk) {
        ServerConnection serverConnection = this.conn;
        synchronized (serverConnection) {
            this.checkWritten();
            if (!(this.headWritten || this.version == HttpVersion.HTTP_1_0 || this.chunked || this.contentLengthSet())) {
                throw new IllegalStateException("You must set the Content-Length header to be the total size of the message body BEFORE sending any data if you are not using HTTP chunked encoding.");
            }
            this.bytesWritten += (long)chunk.readableBytes();
            if (!this.headWritten) {
                this.prepareHeaders();
                this.channelFuture = this.conn.writeToChannel(new AssembledHttpResponse(this.response, chunk));
            } else {
                this.channelFuture = this.conn.writeToChannel(new DefaultHttpContent(chunk));
            }
            return this;
        }
    }

    @Override
    public int streamId() {
        return -1;
    }

    @Override
    public void reset(long code) {
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, null, path, headers, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, path, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String path, Handler<AsyncResult<HttpServerResponse>> handler) {
        return this.push(method, path, null, null, handler);
    }

    @Override
    public HttpServerResponse push(HttpMethod method, String host, String path, MultiMap headers, Handler<AsyncResult<HttpServerResponse>> handler) {
        handler.handle(Future.failedFuture("Push promise is only supported with HTTP2"));
        return this;
    }

    @Override
    public HttpServerResponse writeCustomFrame(int type, int flags, Buffer payload) {
        return this;
    }
}

