/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2Exception;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.impl.ConnectionManager;
import io.vertx.core.http.impl.Http2ClientConnection;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.HttpClientImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandlerBuilder;
import io.vertx.core.http.impl.Waiter;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class Http2Pool
implements ConnectionManager.Pool<Http2ClientConnection> {
    private final ConnectionManager.ConnQueue queue;
    private final Set<Http2ClientConnection> allConnections = new HashSet<Http2ClientConnection>();
    private final Map<Channel, ? super Http2ClientConnection> connectionMap;
    final HttpClientImpl client;
    final HttpClientMetrics metrics;
    final int maxConcurrency;
    final boolean logEnabled;
    final int maxSockets;
    final int windowSize;

    public Http2Pool(ConnectionManager.ConnQueue queue, HttpClientImpl client, HttpClientMetrics metrics, Map<Channel, ? super Http2ClientConnection> connectionMap, int maxConcurrency, boolean logEnabled, int maxSize, int windowSize) {
        this.queue = queue;
        this.client = client;
        this.metrics = metrics;
        this.connectionMap = connectionMap;
        this.maxConcurrency = maxConcurrency;
        this.logEnabled = logEnabled;
        this.maxSockets = maxSize;
        this.windowSize = windowSize;
    }

    @Override
    public HttpVersion version() {
        return HttpVersion.HTTP_2;
    }

    @Override
    public boolean canCreateConnection(int connCount) {
        return connCount == this.allConnections.size() && connCount < this.maxSockets;
    }

    @Override
    public Http2ClientConnection pollConnection() {
        for (Http2ClientConnection conn : this.allConnections) {
            if (!this.canReserveStream(conn)) continue;
            ++conn.streamCount;
            return conn;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createConn(ContextImpl context, Channel ch, Waiter waiter, boolean upgrade) throws Http2Exception {
        ChannelPipeline p = ch.pipeline();
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            Http2ConnectionHandler handler = ((VertxHttp2ConnectionHandlerBuilder)new VertxHttp2ConnectionHandlerBuilder<Http2ClientConnection>().connectionMap(this.connectionMap).server(false)).useCompression(this.client.getOptions().isTryUseCompression()).initialSettings(this.client.getOptions().getInitialSettings()).connectionFactory(connHandler -> {
                Http2ClientConnection conn = new Http2ClientConnection(this, this.queue.metric, context, ch, (VertxHttp2ConnectionHandler)connHandler, this.metrics);
                Object metric = this.metrics.connected(conn.remoteAddress(), conn.remoteName());
                conn.metric(metric);
                return conn;
            }).logEnabled(this.logEnabled).build();
            if (upgrade) {
                handler.onHttpClientUpgrade();
            }
            Http2ClientConnection conn = (Http2ClientConnection)((VertxHttp2ConnectionHandler)handler).connection;
            this.metrics.endpointConnected(this.queue.metric, conn.metric());
            p.addLast(handler);
            this.allConnections.add(conn);
            if (this.windowSize > 0) {
                conn.setWindowSize(this.windowSize);
            }
            ++conn.streamCount;
            waiter.handleConnection(conn);
            this.queue.deliverStream(conn, waiter);
            this.checkPending(conn);
        }
    }

    private boolean canReserveStream(Http2ClientConnection handler) {
        int maxConcurrentStreams = Math.min(handler.handler.connection().local().maxActiveStreams(), this.maxConcurrency);
        return handler.streamCount < maxConcurrentStreams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkPending(Http2ClientConnection conn) {
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            Waiter waiter;
            while (this.canReserveStream(conn) && (waiter = this.queue.getNextWaiter()) != null) {
                ++conn.streamCount;
                this.queue.deliverStream(conn, waiter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void discard(Http2ClientConnection conn) {
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            if (this.allConnections.remove(conn)) {
                this.queue.connectionClosed();
            }
        }
        this.metrics.endpointDisconnected(this.queue.metric, conn.metric());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle(Http2ClientConnection conn) {
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            --conn.streamCount;
            this.checkPending(conn);
        }
    }

    @Override
    public HttpClientStream createStream(Http2ClientConnection conn) throws Exception {
        return conn.createStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeAllConnections() {
        ArrayList<Http2ClientConnection> toClose;
        ConnectionManager.ConnQueue connQueue = this.queue;
        synchronized (connQueue) {
            toClose = new ArrayList<Http2ClientConnection>(this.allConnections);
        }
        toClose.forEach(Http2ConnectionBase::close);
    }
}

