/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.http.impl.Http2ConnectionBase;
import io.vertx.core.http.impl.Http2HeadersAdaptor;
import io.vertx.core.http.impl.Http2Pool;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpClientRequestBase;
import io.vertx.core.http.impl.HttpClientRequestImpl;
import io.vertx.core.http.impl.HttpClientRequestPushPromise;
import io.vertx.core.http.impl.HttpClientResponseImpl;
import io.vertx.core.http.impl.HttpClientStream;
import io.vertx.core.http.impl.HttpFrameImpl;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import io.vertx.core.http.impl.VertxHttp2Stream;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.net.NetSocket;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import java.util.Map;

class Http2ClientConnection
extends Http2ConnectionBase
implements HttpClientConnection {
    final Http2Pool http2Pool;
    final HttpClientMetrics metrics;
    final Object queueMetric;
    int streamCount;

    public Http2ClientConnection(Http2Pool http2Pool, Object queueMetric, ContextImpl context, Channel channel, VertxHttp2ConnectionHandler connHandler, HttpClientMetrics metrics) {
        super(channel, context, connHandler);
        this.http2Pool = http2Pool;
        this.metrics = metrics;
        this.queueMetric = queueMetric;
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.metrics;
    }

    @Override
    void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.http2Pool.discard(this);
    }

    @Override
    void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        super.onGoAwayReceived(lastStreamId, errorCode, debugData);
        this.http2Pool.discard(this);
    }

    @Override
    void onStreamClosed(Http2Stream nettyStream) {
        super.onStreamClosed(nettyStream);
        this.http2Pool.recycle(this);
    }

    synchronized HttpClientStream createStream() throws Http2Exception {
        Http2Connection conn = this.handler.connection();
        Http2Stream stream = conn.local().createStream(conn.local().incrementAndGetNextStreamId(), false);
        boolean writable = this.handler.encoder().flowController().isWritable(stream);
        Http2ClientStream clientStream = new Http2ClientStream(this, stream, writable);
        this.streams.put(clientStream.stream.id(), clientStream);
        return clientStream;
    }

    @Override
    public synchronized void handleClosed() {
        this.http2Pool.discard(this);
        super.handleClosed();
    }

    @Override
    public boolean isValid() {
        Http2Connection conn = this.handler.connection();
        return !this.isClosed() && !conn.goAwaySent() && !conn.goAwayReceived();
    }

    @Override
    public synchronized void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int padding, boolean endOfStream) throws Http2Exception {
        Http2ClientStream stream = (Http2ClientStream)this.streams.get(streamId);
        if (stream != null) {
            this.context.executeFromIO(() -> stream.handleHeaders(headers, endOfStream));
        }
    }

    @Override
    public synchronized void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        Handler<HttpClientRequest> pushHandler;
        Http2ClientStream stream = (Http2ClientStream)this.streams.get(streamId);
        if (stream != null && (pushHandler = stream.pushHandler()) != null) {
            this.context.executeFromIO(() -> {
                String rawMethod = headers.method().toString();
                HttpMethod method = HttpUtils.toVertxMethod(rawMethod);
                String uri = headers.path().toString();
                String host = headers.authority() != null ? headers.authority().toString() : null;
                Http2HeadersAdaptor headersMap = new Http2HeadersAdaptor(headers);
                Http2Stream promisedStream = this.handler.connection().stream(promisedStreamId);
                int port = this.remoteAddress().port();
                HttpClientRequestPushPromise pushReq = new HttpClientRequestPushPromise(this, promisedStream, this.http2Pool.client, this.isSsl(), method, rawMethod, uri, host, port, headersMap);
                if (this.metrics.isEnabled()) {
                    pushReq.metric(this.metrics.responsePushed(this.queueMetric, this.metric(), this.localAddress(), this.remoteAddress(), pushReq));
                }
                this.streams.put(promisedStreamId, pushReq.getStream());
                pushHandler.handle(pushReq);
            });
            return;
        }
        this.handler.writeReset(promisedStreamId, Http2Error.CANCEL.code());
    }

    static class Http2ClientStream
    extends VertxHttp2Stream<Http2ClientConnection>
    implements HttpClientStream {
        private HttpClientRequestBase request;
        private HttpClientResponseImpl response;
        private boolean requestEnded;
        private boolean responseEnded;

        public Http2ClientStream(Http2ClientConnection conn, Http2Stream stream, boolean writable) throws Http2Exception {
            this(conn, null, stream, writable);
        }

        public Http2ClientStream(Http2ClientConnection conn, HttpClientRequestBase request, Http2Stream stream, boolean writable) throws Http2Exception {
            super(conn, stream, writable);
            this.request = request;
        }

        @Override
        public HttpVersion version() {
            return HttpVersion.HTTP_2;
        }

        @Override
        public int id() {
            return super.id();
        }

        @Override
        void handleEnd(MultiMap trailers) {
            if (((Http2ClientConnection)this.conn).metrics.isEnabled()) {
                if (this.request.exceptionOccurred != null) {
                    ((Http2ClientConnection)this.conn).metrics.requestReset(this.request.metric());
                } else {
                    ((Http2ClientConnection)this.conn).metrics.responseEnd(this.request.metric(), this.response);
                }
            }
            this.responseEnded = true;
            if (trailers == null) {
                trailers = new CaseInsensitiveHeaders();
            }
            this.response.handleEnd(null, trailers);
        }

        @Override
        void handleData(Buffer buf) {
            this.response.handleChunk(buf);
        }

        @Override
        void handleReset(long errorCode) {
            if (this.responseEnded) {
                return;
            }
            this.responseEnded = true;
            if (((Http2ClientConnection)this.conn).metrics.isEnabled()) {
                ((Http2ClientConnection)this.conn).metrics.requestReset(this.request.metric());
            }
            this.handleException(new StreamResetException(errorCode));
        }

        @Override
        void handleClose() {
            if (!this.responseEnded) {
                this.responseEnded = true;
                if (((Http2ClientConnection)this.conn).metrics.isEnabled()) {
                    ((Http2ClientConnection)this.conn).metrics.requestReset(this.request.metric());
                }
                this.handleException(new VertxException("Connection was closed"));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void checkDrained() {
            Http2ClientConnection http2ClientConnection = (Http2ClientConnection)this.conn;
            synchronized (http2ClientConnection) {
                this.handleInterestedOpsChanged();
            }
        }

        @Override
        void handleInterestedOpsChanged() {
            if (this.request instanceof HttpClientRequestImpl && !this.isNotWritable() && !this.isNotWritable()) {
                ((HttpClientRequestImpl)this.request).handleDrained();
            }
        }

        @Override
        void handleCustomFrame(int type, int flags, Buffer buff) {
            this.response.handleUnknowFrame(new HttpFrameImpl(type, flags, buff));
        }

        void handleHeaders(Http2Headers headers, boolean end) {
            if (this.response == null || this.response.statusCode() == 100) {
                String statusMessage;
                int status;
                try {
                    status = Integer.parseInt(headers.status().toString());
                    statusMessage = HttpResponseStatus.valueOf(status).reasonPhrase();
                }
                catch (Exception e) {
                    this.handleException(e);
                    this.writeReset(1L);
                    return;
                }
                this.response = new HttpClientResponseImpl(this.request, HttpVersion.HTTP_2, this, status, statusMessage, new Http2HeadersAdaptor(headers));
                if (((Http2ClientConnection)this.conn).metrics.isEnabled()) {
                    ((Http2ClientConnection)this.conn).metrics.responseBegin(this.request.metric(), this.response);
                }
                this.request.handleResponse(this.response);
                if (end) {
                    this.onEnd();
                }
            } else if (end) {
                this.onEnd(new Http2HeadersAdaptor(headers));
            }
        }

        @Override
        void handleException(Throwable exception) {
            if (!this.requestEnded || this.response == null) {
                this.context.executeFromIO(() -> this.request.handleException(exception));
            }
            if (this.response != null) {
                this.context.executeFromIO(() -> this.response.handleException(exception));
            }
        }

        Handler<HttpClientRequest> pushHandler() {
            return ((HttpClientRequestImpl)this.request).pushHandler();
        }

        @Override
        public void writeHead(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked) {
            this.writeHeadWithContent(method, rawMethod, uri, headers, hostHeader, chunked, null, false);
        }

        @Override
        public void writeHeadWithContent(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf content, boolean end) {
            DefaultHttp2Headers h = new DefaultHttp2Headers();
            h.method(method != HttpMethod.OTHER ? method.name() : rawMethod);
            if (method == HttpMethod.CONNECT) {
                if (hostHeader == null) {
                    throw new IllegalArgumentException("Missing :authority / host header");
                }
                h.authority(hostHeader);
            } else {
                h.path(uri);
                h.scheme("https");
                if (hostHeader != null) {
                    h.authority(hostHeader);
                }
            }
            if (headers != null && headers.size() > 0) {
                for (Map.Entry header : headers) {
                    h.add(Http2HeadersAdaptor.toLowerCase((CharSequence)header.getKey()), header.getValue());
                }
            }
            if (((Http2ClientConnection)this.conn).http2Pool.client.getOptions().isTryUseCompression() && h.get(HttpHeaderNames.ACCEPT_ENCODING) == null) {
                h.set(HttpHeaderNames.ACCEPT_ENCODING, HttpHeaders.DEFLATE_GZIP);
            }
            if (((Http2ClientConnection)this.conn).metrics.isEnabled()) {
                this.request.metric(((Http2ClientConnection)this.conn).metrics.requestBegin(((Http2ClientConnection)this.conn).queueMetric, ((Http2ClientConnection)this.conn).metric(), ((Http2ClientConnection)this.conn).localAddress(), ((Http2ClientConnection)this.conn).remoteAddress(), this.request));
            }
            this.writeHeaders(h, end && content == null);
            if (content != null) {
                this.writeBuffer(content, end);
            } else {
                this.handlerContext.flush();
            }
        }

        @Override
        public void writeBuffer(ByteBuf buf, boolean end) {
            if (buf == null && end) {
                buf = Unpooled.EMPTY_BUFFER;
            }
            if (buf != null) {
                this.writeData(buf, end);
            }
            if (end) {
                this.handlerContext.flush();
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            super.writeFrame(type, flags, payload);
        }

        @Override
        public Context getContext() {
            return this.context;
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
        }

        @Override
        public boolean isNotWritable() {
            return super.isNotWritable();
        }

        @Override
        public void beginRequest(HttpClientRequestImpl request) {
            this.request = request;
        }

        @Override
        public void endRequest() {
            if (((Http2ClientConnection)this.conn).metrics.isEnabled()) {
                ((Http2ClientConnection)this.conn).metrics.requestEnd(this.request.metric());
            }
            this.requestEnded = true;
        }

        @Override
        public void resetRequest(long code) {
            if (!this.requestEnded || !this.responseEnded) {
                this.requestEnded = true;
                this.responseEnded = true;
                this.writeReset(code);
                if (((Http2ClientConnection)this.conn).metrics.isEnabled()) {
                    ((Http2ClientConnection)this.conn).metrics.requestReset(this.request.metric());
                }
            }
        }

        @Override
        public void resetResponse(long code) {
            this.resetRequest(code);
        }

        @Override
        public HttpClientConnection connection() {
            return (HttpClientConnection)((Object)this.conn);
        }

        @Override
        public NetSocket createNetSocket() {
            return ((Http2ClientConnection)this.conn).toNetSocket(this);
        }
    }
}

