/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns.impl;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.codec.dns.DatagramDnsQuery;
import io.netty.handler.codec.dns.DatagramDnsQueryEncoder;
import io.netty.handler.codec.dns.DatagramDnsResponseDecoder;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsSection;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.dns.DnsClient;
import io.vertx.core.dns.DnsException;
import io.vertx.core.dns.DnsResponseCode;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.dns.impl.MxRecordImpl;
import io.vertx.core.dns.impl.SrvRecordImpl;
import io.vertx.core.dns.impl.decoder.RecordDecoder;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public final class DnsClientImpl
implements DnsClient {
    private static final char[] HEX_TABLE = "0123456789abcdef".toCharArray();
    private final Bootstrap bootstrap;
    private final InetSocketAddress dnsServer;
    private final ContextImpl actualCtx;

    public DnsClientImpl(VertxInternal vertx, int port, String host) {
        ContextImpl creatingContext = vertx.getContext();
        if (creatingContext != null && creatingContext.isMultiThreadedWorkerContext()) {
            throw new IllegalStateException("Cannot use DnsClient in a multi-threaded worker verticle");
        }
        this.dnsServer = new InetSocketAddress(host, port);
        this.actualCtx = vertx.getOrCreateContext();
        this.bootstrap = new Bootstrap();
        this.bootstrap.group(this.actualCtx.nettyEventLoop());
        this.bootstrap.channel(NioDatagramChannel.class);
        this.bootstrap.option(ChannelOption.ALLOCATOR, PartialPooledByteBufAllocator.INSTANCE);
        this.bootstrap.handler(new ChannelInitializer<DatagramChannel>(){

            @Override
            protected void initChannel(DatagramChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast(new DatagramDnsQueryEncoder());
                pipeline.addLast(new DatagramDnsResponseDecoder());
            }
        });
    }

    @Override
    public DnsClient lookup4(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.A);
        return this;
    }

    @Override
    public DnsClient lookup6(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.AAAA);
        return this;
    }

    @Override
    public DnsClient lookup(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.A, DnsRecordType.AAAA);
        return this;
    }

    @Override
    public DnsClient resolveA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.A);
        return this;
    }

    @Override
    public DnsClient resolveCNAME(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.CNAME);
        return this;
    }

    @Override
    public DnsClient resolveMX(String name, Handler<AsyncResult<List<MxRecord>>> handler) {
        this.lookupList(name, handler, DnsRecordType.MX);
        return this;
    }

    @Override
    public DnsClient resolveTXT(String name, final Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, new Handler<AsyncResult<List<String>>>(){

            @Override
            public void handle(AsyncResult event) {
                if (event.failed()) {
                    handler.handle(event);
                } else {
                    ArrayList txts = new ArrayList();
                    List records = (List)event.result();
                    for (List txt : records) {
                        txts.addAll(txt);
                    }
                    handler.handle(Future.succeededFuture(txts));
                }
            }
        }, DnsRecordType.TXT);
        return this;
    }

    @Override
    public DnsClient resolvePTR(String name, Handler<AsyncResult<String>> handler) {
        this.lookupSingle(name, handler, DnsRecordType.PTR);
        return this;
    }

    @Override
    public DnsClient resolveAAAA(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.AAAA);
        return this;
    }

    @Override
    public DnsClient resolveNS(String name, Handler<AsyncResult<List<String>>> handler) {
        this.lookupList(name, handler, DnsRecordType.NS);
        return this;
    }

    @Override
    public DnsClient resolveSRV(String name, Handler<AsyncResult<List<SrvRecord>>> handler) {
        this.lookupList(name, handler, DnsRecordType.SRV);
        return this;
    }

    @Override
    public DnsClient reverseLookup(String address, Handler<AsyncResult<String>> handler) {
        try {
            InetAddress inetAddress = InetAddress.getByName(address);
            byte[] addr = inetAddress.getAddress();
            StringBuilder reverseName = new StringBuilder(64);
            if (inetAddress instanceof Inet4Address) {
                reverseName.append(addr[3] & 0xFF).append(".").append(addr[2] & 0xFF).append(".").append(addr[1] & 0xFF).append(".").append(addr[0] & 0xFF);
            } else {
                for (int i = 0; i < 16; ++i) {
                    reverseName.append(HEX_TABLE[addr[15 - i] & 0xF]);
                    reverseName.append(".");
                    reverseName.append(HEX_TABLE[addr[15 - i] >> 4 & 0xF]);
                    if (i == 15) continue;
                    reverseName.append(".");
                }
            }
            reverseName.append(".in-addr.arpa");
            return this.resolvePTR(reverseName.toString(), handler);
        }
        catch (UnknownHostException e) {
            this.actualCtx.runOnContext(v -> handler.handle(Future.failedFuture(e)));
            return this;
        }
    }

    private <T> void lookupSingle(String name, Handler<AsyncResult<T>> handler, DnsRecordType ... types) {
        this.lookupList(name, ar -> handler.handle(ar.map(result -> result.isEmpty() ? null : result.get(0))), types);
    }

    private <T> void lookupList(String name, Handler<AsyncResult<List<T>>> handler, DnsRecordType ... types) {
        Future result = Future.future();
        result.setHandler(handler);
        this.lookup(name, result, types);
    }

    private <T> void lookup(final String name, final Future<List<T>> result, final DnsRecordType ... types) {
        Objects.requireNonNull(name, "no null name accepted");
        this.bootstrap.connect(this.dnsServer).addListener(new RetryChannelFutureListener(result){

            @Override
            public void onSuccess(ChannelFuture future) throws Exception {
                DatagramDnsQuery query = new DatagramDnsQuery(null, DnsClientImpl.this.dnsServer, ThreadLocalRandom.current().nextInt());
                for (DnsRecordType type : types) {
                    query.addRecord(DnsSection.QUESTION, new DefaultDnsQuestion(name, type, 1));
                }
                future.channel().writeAndFlush(query).addListener(new RetryChannelFutureListener(result){

                    @Override
                    public void onSuccess(ChannelFuture future) throws Exception {
                        future.channel().pipeline().addLast(new SimpleChannelInboundHandler<DnsResponse>(){

                            @Override
                            protected void channelRead0(ChannelHandlerContext ctx, DnsResponse msg) throws Exception {
                                DnsResponseCode code = DnsResponseCode.valueOf(msg.code().intValue());
                                if (code == DnsResponseCode.NOERROR) {
                                    int count = msg.count(DnsSection.ANSWER);
                                    ArrayList records = new ArrayList(count);
                                    for (int idx = 0; idx < count; ++idx) {
                                        Object a = msg.recordAt(DnsSection.ANSWER, idx);
                                        Object record = RecordDecoder.decode(a);
                                        if (!this.isRequestedType(a.type(), types)) continue;
                                        records.add(record);
                                    }
                                    if (records.size() > 0 && (records.get(0) instanceof MxRecordImpl || records.get(0) instanceof SrvRecordImpl)) {
                                        Collections.sort(records);
                                    }
                                    DnsClientImpl.this.setResult(result, records);
                                } else {
                                    DnsClientImpl.this.setFailure(result, new DnsException(code));
                                }
                                ctx.close();
                            }

                            private boolean isRequestedType(DnsRecordType dnsRecordType, DnsRecordType[] types) {
                                for (DnsRecordType t : types) {
                                    if (!t.equals(dnsRecordType)) continue;
                                    return true;
                                }
                                return false;
                            }

                            @Override
                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                                DnsClientImpl.this.setFailure(result, cause);
                                ctx.close();
                            }
                        });
                    }
                });
            }
        });
    }

    private <T> void setResult(Future<List<T>> r, List<T> result) {
        if (r.isComplete()) {
            return;
        }
        this.actualCtx.executeFromIO(() -> {
            if (result instanceof Throwable) {
                r.fail((Throwable)((Object)result));
            } else {
                r.complete(result);
            }
        });
    }

    private <T> void setFailure(Future<List<T>> r, Throwable err) {
        if (r.isComplete()) {
            return;
        }
        this.actualCtx.executeFromIO(() -> r.fail(err));
    }

    private abstract class RetryChannelFutureListener
    implements ChannelFutureListener {
        private final Future result;

        RetryChannelFutureListener(Future result) {
            this.result = result;
        }

        @Override
        public final void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                if (!this.result.isComplete()) {
                    this.result.fail(future.cause());
                }
            } else {
                this.onSuccess(future);
            }
        }

        protected abstract void onSuccess(ChannelFuture var1) throws Exception;
    }
}

