/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.datagram.impl;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.DatagramChannel;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.datagram.DatagramPacket;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.datagram.impl.DatagramChannelFutureListener;
import io.vertx.core.datagram.impl.DatagramServerHandler;
import io.vertx.core.datagram.impl.InternetProtocolFamily;
import io.vertx.core.datagram.impl.PacketWriteStreamImpl;
import io.vertx.core.impl.Arguments;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.core.net.impl.PartialPooledByteBufAllocator;
import io.vertx.core.net.impl.SocketAddressImpl;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.core.streams.WriteStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Objects;

public class DatagramSocketImpl
extends ConnectionBase
implements DatagramSocket,
MetricsProvider {
    private Handler<DatagramPacket> packetHandler;
    private DatagramSocketMetrics metrics;

    public DatagramSocketImpl(VertxInternal vertx, DatagramSocketOptions options) {
        super(vertx, DatagramSocketImpl.createChannel(options.isIpV6() ? InternetProtocolFamily.IPv6 : InternetProtocolFamily.IPv4, new DatagramSocketOptions(options)), vertx.getOrCreateContext());
        ContextImpl creatingContext = vertx.getContext();
        if (creatingContext != null && creatingContext.isMultiThreadedWorkerContext()) {
            throw new IllegalStateException("Cannot use DatagramSocket in a multi-threaded worker verticle");
        }
        this.channel().config().setOption(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, true);
        this.context.nettyEventLoop().register(this.channel);
        if (options.getLogActivity()) {
            this.channel().pipeline().addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        this.channel.pipeline().addLast("handler", (ChannelHandler)new DatagramServerHandler(this));
        this.channel().config().setMaxMessagesPerRead(1);
        this.channel().config().setAllocator(PartialPooledByteBufAllocator.INSTANCE);
        this.metrics = vertx.metricsSPI().createMetrics(this, options);
    }

    @Override
    public DatagramSocketMetrics metrics() {
        return this.metrics;
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            this.addListener(this.channel().joinGroup(InetAddress.getByName(multicastAddress)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket listenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            InetAddress sourceAddress = source == null ? null : InetAddress.getByName(source);
            this.addListener(this.channel().joinGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            this.addListener(this.channel().leaveGroup(InetAddress.getByName(multicastAddress)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket unlistenMulticastGroup(String multicastAddress, String networkInterface, String source, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            InetAddress sourceAddress = source == null ? null : InetAddress.getByName(source);
            this.addListener(this.channel().leaveGroup(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String networkInterface, String sourceToBlock, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            InetAddress sourceAddress = sourceToBlock == null ? null : InetAddress.getByName(sourceToBlock);
            this.addListener(this.channel().block(InetAddress.getByName(multicastAddress), NetworkInterface.getByName(networkInterface), sourceAddress), handler);
        }
        catch (Exception e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket blockMulticastGroup(String multicastAddress, String sourceToBlock, Handler<AsyncResult<DatagramSocket>> handler) {
        try {
            this.addListener(this.channel().block(InetAddress.getByName(multicastAddress), InetAddress.getByName(sourceToBlock)), handler);
        }
        catch (UnknownHostException e) {
            this.notifyException(handler, e);
        }
        return this;
    }

    @Override
    public DatagramSocket listen(int port, String address, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.listen(new SocketAddressImpl(port, address), handler);
    }

    @Override
    public synchronized DatagramSocket handler(Handler<DatagramPacket> handler) {
        this.packetHandler = handler;
        return this;
    }

    @Override
    public DatagramSocketImpl endHandler(Handler<Void> endHandler) {
        return (DatagramSocketImpl)super.closeHandler(endHandler);
    }

    @Override
    public DatagramSocketImpl exceptionHandler(Handler<Throwable> handler) {
        return (DatagramSocketImpl)super.exceptionHandler(handler);
    }

    private DatagramSocket listen(SocketAddress local, Handler<AsyncResult<DatagramSocket>> handler) {
        Objects.requireNonNull(handler, "no null handler accepted");
        this.vertx.resolveAddress(local.host(), res -> {
            if (res.succeeded()) {
                ChannelFuture future = this.channel().bind(new InetSocketAddress((InetAddress)res.result(), local.port()));
                this.addListener(future, ar -> {
                    if (ar.succeeded()) {
                        this.metrics.listening(local.host(), this.localAddress());
                    }
                    handler.handle((AsyncResult<DatagramSocket>)ar);
                });
            } else {
                handler.handle(Future.failedFuture(res.cause()));
            }
        });
        return this;
    }

    final void addListener(ChannelFuture future, Handler<AsyncResult<DatagramSocket>> handler) {
        if (handler != null) {
            future.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)new DatagramChannelFutureListener<DatagramSocketImpl>(this, handler, this.context));
        }
    }

    @Override
    public DatagramSocket pause() {
        this.doPause();
        return this;
    }

    @Override
    public DatagramSocket resume() {
        this.doResume();
        return this;
    }

    @Override
    public DatagramSocket send(Buffer packet, int port, String host, Handler<AsyncResult<DatagramSocket>> handler) {
        Objects.requireNonNull(packet, "no null packet accepted");
        Objects.requireNonNull(host, "no null host accepted");
        InetSocketAddress addr = InetSocketAddress.createUnresolved(host, port);
        if (addr.isUnresolved()) {
            this.vertx.resolveAddress(host, res -> {
                if (res.succeeded()) {
                    this.doSend(packet, new InetSocketAddress((InetAddress)res.result(), port), handler);
                } else {
                    handler.handle(Future.failedFuture(res.cause()));
                }
            });
        } else {
            this.doSend(packet, addr, handler);
        }
        if (this.metrics.isEnabled()) {
            this.metrics.bytesWritten(null, new SocketAddressImpl(port, host), packet.length());
        }
        return this;
    }

    private void doSend(Buffer packet, InetSocketAddress addr, Handler<AsyncResult<DatagramSocket>> handler) {
        ChannelFuture future = this.channel().writeAndFlush(new io.netty.channel.socket.DatagramPacket(packet.getByteBuf(), addr));
        this.addListener(future, handler);
    }

    @Override
    public WriteStream<Buffer> sender(int port, String host) {
        Arguments.requireInRange(port, 0, 65535, "port p must be in range 0 <= p <= 65535");
        Objects.requireNonNull(host, "no null host accepted");
        return new PacketWriteStreamImpl(this, port, host);
    }

    @Override
    public DatagramSocket send(String str, int port, String host, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.send(Buffer.buffer(str), port, host, handler);
    }

    @Override
    public DatagramSocket send(String str, String enc, int port, String host, Handler<AsyncResult<DatagramSocket>> handler) {
        return this.send(Buffer.buffer(str, enc), port, host, handler);
    }

    @Override
    public void close(Handler<AsyncResult<Void>> handler) {
        this.endReadAndFlush();
        this.metrics.close();
        ChannelFuture future = this.channel.close();
        if (handler != null) {
            future.addListener((GenericFutureListener<? extends io.netty.util.concurrent.Future<? super Void>>)new DatagramChannelFutureListener<Object>(null, handler, this.context));
        }
    }

    @Override
    public boolean isMetricsEnabled() {
        return this.metrics != null && this.metrics.isEnabled();
    }

    @Override
    public Metrics getMetrics() {
        return this.metrics;
    }

    protected DatagramChannel channel() {
        return (DatagramChannel)this.channel;
    }

    private static NioDatagramChannel createChannel(InternetProtocolFamily family, DatagramSocketOptions options) {
        NioDatagramChannel channel;
        if (family == null) {
            channel = new NioDatagramChannel();
        } else {
            switch (family) {
                case IPv4: {
                    channel = new NioDatagramChannel(io.netty.channel.socket.InternetProtocolFamily.IPv4);
                    break;
                }
                case IPv6: {
                    channel = new NioDatagramChannel(io.netty.channel.socket.InternetProtocolFamily.IPv6);
                    break;
                }
                default: {
                    channel = new NioDatagramChannel();
                }
            }
        }
        if (options.getSendBufferSize() != -1) {
            channel.config().setSendBufferSize(options.getSendBufferSize());
        }
        if (options.getReceiveBufferSize() != -1) {
            channel.config().setReceiveBufferSize(options.getReceiveBufferSize());
            channel.config().setRecvByteBufAllocator(new FixedRecvByteBufAllocator(options.getReceiveBufferSize()));
        }
        channel.config().setReuseAddress(options.isReuseAddress());
        if (options.getTrafficClass() != -1) {
            channel.config().setTrafficClass(options.getTrafficClass());
        }
        channel.config().setBroadcast(options.isBroadcast());
        channel.config().setLoopbackModeDisabled(options.isLoopbackModeDisabled());
        if (options.getMulticastTimeToLive() != -1) {
            channel.config().setTimeToLive(options.getMulticastTimeToLive());
        }
        if (options.getMulticastNetworkInterface() != null) {
            try {
                channel.config().setNetworkInterface(NetworkInterface.getByName(options.getMulticastNetworkInterface()));
            }
            catch (SocketException e) {
                throw new IllegalArgumentException("Could not find network interface with name " + options.getMulticastNetworkInterface());
            }
        }
        return channel;
    }

    private void notifyException(Handler<AsyncResult<DatagramSocket>> handler, Throwable cause) {
        this.context.executeFromIO(() -> handler.handle(Future.failedFuture(cause)));
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    protected void handleClosed() {
        this.checkContext();
        super.handleClosed();
    }

    synchronized void handlePacket(DatagramPacket packet) {
        if (this.metrics.isEnabled()) {
            this.metrics.bytesRead(null, packet.sender(), packet.data().length());
        }
        if (this.packetHandler != null) {
            this.packetHandler.handle(packet);
        }
    }

    @Override
    protected void handleInterestedOpsChanged() {
    }
}

