/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.jaxrs;

import java.security.Principal;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import net.trajano.ms.core.JwtClaimsSetPrincipal;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

public class JwtSecurityContext
implements SecurityContext {
    private final JwtClaimsSetPrincipal principal;
    private final Set<String> roles;
    private final boolean secure;

    public JwtSecurityContext(JwtClaims claims, UriInfo uriInfo) {
        try {
            this.principal = new JwtClaimsSetPrincipal(claims);
            this.secure = "https".equals(uriInfo.getRequestUri().getScheme());
            this.roles = Collections.unmodifiableSet(claims.getStringListClaimValue("roles").parallelStream().collect(Collectors.toSet()));
        }
        catch (MalformedClaimException e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    public String getAuthenticationScheme() {
        return "X-JWT-Assertion";
    }

    public Principal getUserPrincipal() {
        return this.principal;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }
}

