/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.jaxrs;

import java.net.URI;
import javax.ws.rs.container.ContainerRequestContext;
import net.trajano.ms.vertx.jaxrs.JwksUriProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
public class JwksFromHeaderUriProvider
implements JwksUriProvider {
    private static final Logger LOG = LoggerFactory.getLogger(JwksFromHeaderUriProvider.class);
    @Autowired(required=false)
    @Qualifier(value="authz.signature.jwks.uri")
    private URI signatureJwksUri;

    @Override
    public URI getUri(ContainerRequestContext requestContext) {
        if (this.signatureJwksUri != null) {
            return this.signatureJwksUri;
        }
        String jwksUriFromHeader = requestContext.getHeaderString("X-JWKS-URI");
        if (jwksUriFromHeader != null) {
            return URI.create(jwksUriFromHeader);
        }
        LOG.warn("Neither `authz.signature.jwks.uri` was specified nor `X-JWKS-URI` was found in the header, signature verification will not be performed");
        return null;
    }
}

