/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx.beans;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.io.Writer;
import net.trajano.ms.core.JsonOps;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GsonJacksonJsonOps
implements JsonOps {
    @Autowired
    private Gson gson;
    @Autowired
    private ObjectMapper objectMapper;

    public <T> T fromJson(Reader src, Class<T> to) {
        try {
            return (T)this.objectMapper.readerFor(to).readValue(src);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public JsonElement toJsonElement(Reader s) {
        return (JsonElement)this.gson.fromJson(s, JsonElement.class);
    }

    public void writeTo(Object src, Writer writer) throws IOException {
        this.objectMapper.writer().writeValue(writer, src);
    }
}

