/*
 * Decompiled with CFR 0.152.
 */
package net.trajano.ms.vertx;

import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import net.trajano.ms.engine.internal.spring.SpringConfiguration;
import net.trajano.ms.engine.jaxrs.JaxRsRouter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.ComponentScans;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScans(value={@ComponentScan, @ComponentScan(basePackageClasses={SpringConfiguration.class, JaxRsRouter.class})})
public class VertxConfig {
    @Value(value="${http.client.idle_timeout:60}")
    private int httpClientIdleTimeout;
    @Value(value="${http.client.proxy.host:#{null}}")
    private String httpClientProxyHost;
    @Value(value="${http.client.proxy.password:#{null}}")
    private String httpClientProxyPassword;
    @Value(value="${http.client.proxy.port:3128}")
    private int httpClientProxyPort;
    @Value(value="${http.client.proxy.proxyType:HTTP}")
    private ProxyType httpClientProxyType;
    @Value(value="${http.client.proxy.username:#{null}}")
    private String httpClientProxyUsername;
    @Value(value="${http.port:8900}")
    private int httpPort;
    @Value(value="${vertx.warningExceptionTime:1}")
    private long vertxWarningExceptionTime;
    @Value(value="${vertx.workerPoolSize:5000}")
    private int vertxWorkerPoolSize;

    @Bean
    public AddressResolverOptions addressResolverOptions() {
        return new AddressResolverOptions().setMaxQueries(10);
    }

    @Bean
    public HttpClientOptions httpClientOptions() {
        HttpClientOptions options = new HttpClientOptions().setIdleTimeout(this.httpClientIdleTimeout).setPipelining(true);
        if (this.httpClientProxyHost != null) {
            ProxyOptions proxyOptions = new ProxyOptions().setHost(this.httpClientProxyHost).setPort(this.httpClientProxyPort).setType(this.httpClientProxyType).setUsername(this.httpClientProxyUsername).setPassword(this.httpClientProxyPassword);
            options.setProxyOptions(proxyOptions);
        }
        return options;
    }

    @Bean
    public HttpServerOptions httpServerOptions() {
        return new HttpServerOptions().setPort(this.httpPort);
    }

    @Bean
    public VertxOptions vertxOptions(AddressResolverOptions addressResolverOptions) {
        return new VertxOptions().setAddressResolverOptions(addressResolverOptions).setWarningExceptionTime(this.vertxWarningExceptionTime).setWorkerPoolSize(this.vertxWorkerPoolSize);
    }
}

